package ballworlds.ball;

import java.awt.Color;
import java.awt.geom.Point2D;

import ballworlds.framework.BallEnvironment;

/**
 * A DudThatMoves behaves exactly like a Dud (including random location),
 * except that it moves, on its own, in a straight line
 * (i.e., a constant velocity).
 * 
 * @author David Mutchler. Created March 20, 2009.
 */
public class DudThatMoves extends Dud {
	private static Point2D DUD_THAT_MOVES_VELOCITY =
		new Point2D.Double(0.1, -0.05);
	private static Color DUD_THAT_MOVES_COLOR = Color.darkGray;
	
	private Point2D velocity;

	/**
	 * Adds the DudThatMoves to its World at a random location
	 * with the default color and diameter for a DudThatMoves,
	 * and with a constant velocity.
	 *
	 * @param ballEnvironment the object that manages Balls in this World
	 */
	public DudThatMoves(BallEnvironment ballEnvironment) {
		super(ballEnvironment);
		
		this.setVelocity(DudThatMoves.DUD_THAT_MOVES_VELOCITY);
		this.setColor(DudThatMoves.DUD_THAT_MOVES_COLOR);
	}
	
	/**
	 * Move the DudThatMoves per its constant velocity.
	 */
	@Override
	public void act() {
		this.setLocation(new Point2D.Double(
				this.getLocation().getX() + this.getVelocity().getX(),
				this.getLocation().getY() + this.getVelocity().getY()));
	}

	/**
	 * Sets the field called 'velocity' to the given value.
	 * @param velocity The velocity to set.
	 */
	protected void setVelocity(Point2D velocity) {
		this.velocity = velocity;
	}

	/**
	 * Returns the value of the field called 'velocity'.
	 * @return Returns the velocity.
	 */
	protected Point2D getVelocity() {
		return this.velocity;
	}
}
