package ballworlds.ball;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;

import ballworlds.framework.BallEnvironment;

/**
 *  A Dud is a Ball that merely appears on the screen.
 *  Each Dud appears in a random location in its World.
 *
 * @author David Mutchler. Created March 20, 2009.
 */
public class Dud extends Ball {
	private static Color DUD_COLOR = Color.black;
	private static double DUD_DIAMETER = 15.0;

	private Color color;
	private Point2D location;
	private double diameter;
	private BallEnvironment ballEnvironment;
	
	/**
	 * Adds the Dud to its World at a random location
	 * with the default color and diameter for Dud's.
	 *
	 * @param ballEnvironment the object that manages Balls in this World
	 */
	public Dud(BallEnvironment ballEnvironment) {
		super(ballEnvironment);
		this.ballEnvironment = ballEnvironment;
		this.ballEnvironment.addBall(this);
		
		this.color = Dud.DUD_COLOR;
		
		double worldWidth = this.ballEnvironment.middleOfWorld().getX() * 2;
		double worldHeight = this.ballEnvironment.middleOfWorld().getY() * 2;
		this.location = new Point2D.Double(
				Math.random() * worldWidth,
				Math.random() * worldHeight);
		
		this.diameter = Dud.DUD_DIAMETER;
	}

	@Override
	public Color getColor() {
		return this.color;
	}

	@Override
	public Shape getShape() {
		return new Ellipse2D.Double(this.location.getX(), this.location.getY(),
									this.diameter, this.diameter);
	}

	@Override
	public double distanceFrom(Point2D point) {
		return Double.MAX_VALUE;  // So Dud's are never selected
	}

	@Override
	public void moveTo(Point2D point) {
		// Not implemented for a Dud
	}

	@Override
	public void act() {
		// Not implemented for a Dud
	}

	@Override
	public void die() {
		// Not implemented for a Dud
	}

	@Override
	public void pauseOrResume() {
		// Not implemented for a Dud
	}

	/**
	 * Returns the value of the field called 'location'.
	 * @return Returns the location.
	 */
	protected final Point2D getLocation() {
		return this.location;
	}

	/**
	 * Sets the field called 'location' to the given value.
	 * @param location The location to set.
	 */
	protected final void setLocation(Point2D location) {
		this.location = location;
	}

	/**
	 * Sets the field called 'color' to the given value.
	 * @param color The color to set.
	 */
	protected final void setColor(Color color) {
		this.color = color;
	}
	
	/**
	 * Returns the value of the field called 'ballEnvironment'.
	 * @return Returns the ballEnvironment.
	 */
	protected final BallEnvironment getBallEnvironment() {
		return this.ballEnvironment;
	}

	/**
	 * Returns the value of the field called 'diameter'.
	 * @return Returns the diameter.
	 */
	protected final double getDiameter() {
		return this.diameter;
	}

	/**
	 * Sets the field called 'diameter' to the given value.
	 * @param diameter The diameter to set.
	 */
	protected final void setDiameter(double diameter) {
		this.diameter = diameter;
	}
}
