package ballworlds.ball;

import java.awt.Color;
import java.awt.geom.Point2D;

import ballworlds.framework.BallEnvironment;

/**
 * A Bouncer behaves just like a Mover,
 * except that it bounces off the edges of its World. 
 *
 * @author David Mutchler. Created March 20, 2009.
 */
public class Bouncer extends Mover {
	private static Color BOUNCER_COLOR = Color.yellow;
	
	/**
	 * Adds the Bouncer to its World at the middle of the World
	 * with the default color and diameter for a Bouncer,
	 * and with a constant but randomly chosen velocity.
	 *
	 * @param ballEnvironment the object that manages Balls in this World
	 */
	public Bouncer(BallEnvironment ballEnvironment) {
		super(ballEnvironment);
		
		this.setColor(Bouncer.BOUNCER_COLOR);
	}

	/**
	 * Act (possibly bouncing) unless the Bouncer is paused.
	 */
	@Override
	public void act() {
		if (! this.isPaused()) {
			super.act();
			
			// bounce if any part of the Ball is outside of the World
			
			Point2D upperLeft = this.getLocation();
			Point2D lowerRight = new Point2D.Double(
					upperLeft.getX() + this.getDiameter(),
					upperLeft.getY() + this.getDiameter());
			
			if (! this.getBallEnvironment().isInsideWorldX(upperLeft)
				|| ! this.getBallEnvironment().isInsideWorldX(lowerRight)) {
					this.setVelocity(new Point2D.Double(
							- this.getVelocity().getX(),
							this.getVelocity().getY()));
			}
			
			if (! this.getBallEnvironment().isInsideWorldY(upperLeft)
					|| ! this.getBallEnvironment().isInsideWorldY(lowerRight)) {
						this.setVelocity(new Point2D.Double(
								this.getVelocity().getX(),
								- this.getVelocity().getY()));
			}
		}
	}
}
