package ballworlds.framework;

import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.JFrame;

/** 
 * The JFrame which is the primary window for BallWorlds.
 * As each World is constructed, its visual elements are added to this frame.
 *  
 * @author David Mutchler, Salman Azhar and others, January 2005.
 * Modified September, 2008.
 */
public class BallWorldsFrame extends JFrame {
	
	// Default size and title of the frame
	private static final Dimension SIZE = new Dimension(1024, 750);
	private static final String TITLE = "BallWorlds";
	
	/**
     * Initializes the size, title, layout manager and on-close behavior of this frame.
     */
    public BallWorldsFrame() {
    	this.setSize(BallWorldsFrame.SIZE);
    	this.setTitle(BallWorldsFrame.TITLE);
    	this.setLayout(new FlowLayout());
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}
}
