package ballworlds.ball;

import ballworlds.framework.Animate;
import ballworlds.framework.BallEnvironment;
import ballworlds.framework.Drawable;
import ballworlds.framework.Relocatable;

/**
 * A Ball is an abstract class that does nothing -- it is just a convenient name
 * for a "generic" ball, that is, any Drawable, Relocatable, Animate object.
 *
 * <p>
 * Specific kinds of Balls are expected to do other things like move on their own,
 * bounce, shrink and grow in size, explode, and be draggable by the mouse.
 *
 * <p>
 * Specific kinds of Balls should extend this class, simply so that
 * they can be declared to be a Ball in classes that refer to a generic Ball.
 *
 * <p>
 * A Ball must have a constructor that:
 * <ul>
 *   <li> Takes a BallEnvironment object and
 *   <li> Uses that BallEnvironment object to add the Ball to its World
 *        (otherwise, the Ball is neither displayed nor asked to act).
 * </ul>
 *
 * <p>
 * <b>
 * Students: you should NOT add any code to this abstract Ball class.
 * Instead, write classes that extend this Ball class.
 * </b>
 *
 * @author David Mutchler, Salman Azhar and others, January 2005.
 * Modified September, 2008.
 */
public abstract class Ball implements Drawable, Relocatable, Animate {
	
	/**
	 * Adds itself to its World (otherwise, the Ball is neither displayed
	 * nor asked to act).
	 *
	 * This stub does nothing. Specific kinds of Balls should override
	 * this constructor so that it accomplishes the above.
	 *
	 * @param ballEnvironment The BallEnvironment for all the Balls in this Ball's World.
	 */
	public Ball(BallEnvironment ballEnvironment) {
		// Does nothing, should be overridden.
	}
}
