import java.awt.Color;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

import javax.swing.JButton;


/**
 * undoes the last thing drawn
 *
 * @author Matthew Drosos and Colin DeClue.
 *         Created Apr 14, 2008.
 */
public class UndoButton extends JButton implements ActionListener {
	
	private ArrayList<Shape> shapes;
	private ArrayList<Boolean> fill;
	private ArrayList<Color> colors;
	private ArrayList<WorldPanel> panels;
	private Tool currentTool;
	
	/**
	 * deletes the last shape drawn
	 *
	 * @param shapes - an arrayList of shapes to be drawn to the world panel
	 * @param fill - an ArrayList of booleans corresponding to shapes
	 * @param colors - an ArrayList of colors corresponding to shapes
	 * @param panels the world panel being used
	 * @param currentTool current tool being used
	 */
	public UndoButton(ArrayList<Shape> shapes, ArrayList<Boolean> fill, ArrayList<Color> colors, ArrayList<WorldPanel> panels, Tool currentTool)
	{
		this.fill = fill;
		this.colors = colors;
		this.shapes = shapes;
		this.panels = panels;
		this.currentTool = currentTool;
	}
	
	public void actionPerformed(ActionEvent e) {
		if(this.shapes.size() != 0)
		{
			this.shapes.remove(this.shapes.size() - 1);
			this.fill.remove(this.fill.size() - 1);
			this.colors.remove(this.colors.size() - 1);
			this.panels.get(0).resetShapesIndex();
		}
		
		if((this.currentTool instanceof Pencil || this.currentTool instanceof Brush || this.currentTool instanceof Polygon) && this.shapes.size() != 0)
		{
			while(!(this.shapes.get(this.shapes.size() - 1) instanceof Ellipse2D.Double) && (!(this.shapes.get(this.shapes.size()-1) instanceof Rectangle2D.Double)))
			{
				this.shapes.remove(this.shapes.size() - 1);
				this.fill.remove(this.fill.size() - 1);
				this.colors.remove(this.colors.size() - 1);
				this.panels.get(0).resetShapesIndex();
				if(this.shapes.size() == 0)
				{
					break;
				}
			}
		}
		
		if(this.shapes.size() != 0)
		{
			this.shapes.remove(this.shapes.size() - 1);
			this.fill.remove(this.fill.size() - 1);
			this.colors.remove(this.colors.size() - 1);
			this.panels.get(0).resetShapesIndex();
		}

		
	}
}
