import java.awt.event.MouseEvent;


/**
 * the interface that allows shapes to be drawn to the window
 *
 * @author Matt Drosos and Colin DeClue.
 *         Created Apr 8, 2008.
 */
public interface Tool {
	
	/**
	 * if clicked, the WorldPanel performs a certain action
	 *
	 * @param event
	 */
	public void clicked(MouseEvent event);
	
	/**
	 * if dragged, the WorldPanel performs a certain action
	 *
	 * @param event
	 */
	public void dragged(MouseEvent event);
	
	/**
	 * if release, the WorldPanel performs a certain action
	 *
	 * @param event
	 */
	public void release(MouseEvent event);
	
	/**
	 * if pressed, the WorldPanel performs a certain action
	 *
	 * @param event
	 */
	public void pressed(MouseEvent event);
	
}
