function result = ratlist(xleft,xright,n,R)
% Divides the interval (xleft,xright) into n parts, using progression 
% ratio R.  The length of the second sub-interval is R times the length of 
% of the first sub-interval.  Result is a row vector of length n+1.  It is 
% a list of x locations (xleft ... xright).

Rlist = ones(1,n); 
for i=2:n;                 % produces Rlist = [1 R R^2 R^3 ... R^n]
   Rlist(i) = Rlist(i-1)*R;
end;

Rsum = sum(Rlist);

result = zeros(1,n+1);
result(1) = xleft;
result(n+1) = xright;
result(2) = xleft + (xright - xleft)/Rsum;
for i=3:n;
   result(i) = result(i-1) + R*(result(i-1) - result(i-2));
end;

return;

