function ELCON = quadcon(elwide, eltall)
% usage:  ELCON = quadcon(elwide, eltall)
% generates element connectivity table for a simple, regular mesh.
% The table is a nelements by 4 array, one table row per element.  
% Nodes and elements are numbered top to bottom, left to right.
% The inputs elwide and eltall are the number of elements wide and tall
% the grid is.

% check input
if elwide >= 1 & eltall >= 1
  % accept the input data (elwide and eltall)
else
  error('inputs must be >= 1')
end

% setup
nelements = elwide * eltall;
first_el = zeros(1,4);
first_row = zeros(elwide,4);
ELCON = zeros(nelements,4);

first_el = [2 eltall+3 eltall+2 1];	% con table for first element

% constuct connection table for first column of elements
for i=1:eltall,
  first_col(i,:) = first_el + (i-1);
end

% construct element connectivity table a column of elements at a time
for j=1:elwide,
  ELCON(1+(j-1)*eltall:j*eltall,:)=first_col + ((j-1)*(eltall+1));
end

  
  
  
