% FEm.PSE toolbox version 1.0, Sept 7, 1998.
% Author: Mike Taylor mtaylor@cfdlab.engr.utk.edu
%
% General finite element programming enviroment in Matlab.  Capabilities
% include line elements with linear, quadratic, and cubic LaGrange bases, 
% linear triangles, linear quad elements with no quadrature, multiple
% degrees of freedom per node, non-linear problems, and unsteady
% problems.  
%
% *1D assembly routines*:  asjac1D, asres1D
% asjac1D and asres1D assemble jacobian and residuals for 1D problems
% using linear, quadratic, or cubic LaGrange elements.
%
% *General assembly routines*:  asjac, asres
% Used for 2D elements and 1D elements in 2D problems
%
% *Linear triangle support routines*:
% All of these routines have names ending in _2Dt.m.  All of these
% routines are designed to use the output of the Matlab "delaunay"
% routine as input.
% do_ZETAe_2Dt - calculates element zeta(i) by x(j) derivitives
% do_DIFFe_2Dt - calculates element isotropic diffusion matrices
% do_KUUe_2Dt - calculates element matrices for plane stress/strain
% do_KUVe_2Dt - calculates element matrices for plane stress/strain
% do_KVUe_2Dt - calculates element matrices for plane stress/strain
% do_KVVe_2Dt - calculates element matrices for plane stress/strain
%
% *Linear quad support routines*:
% Quad elements are implemented here with no quadrature.
% quadcon - builds a connectivity table for a tensor product mesh.  Uses
%   the output of the Matlab routine "meshgrid" as input.
% do_ETAe_q0 - calculates element eta(i) by x(j) derivitives
% do_DIFFe_q0 - calculates element isotropic diffusion matrices
%
% *Boundry condition support routines*:
% do_diri - imposes Dirichlet conditions for linear problems on jacobian
%   and residual before linear solve.
% do_linecon - generates a nodal connectivity table for use with
%   asjac/asres from a list of global node numbers
% do_le2D - generates elements lengths for line elements in 2D problems
% 
% *Miscelanous*
% threadit, unthreadit - supports multiple degrees of freedom per node by 
%   reducing matrix bandwith.
% ratlist - used to generate non-uniform 1D meshes or 2D mesh seeds via a 
%   progression ratio
