function linecon = do_linecon(nodelist)
% usage linecon = do_linecon(nodelist)
% given an ordered list of node numbers, do_linecon builds a nodal
% connectivity array for linear basis line elements.  It returns this
% data in a form suitable for assembly with asjac or asres.

nodelist = nodelist(:);			% write nodelist out as a column array
nline = size(nodelist,1);		% number of nodes in the list
linecon = zeros(nline-1,2);		% reserve memory for linecon
linecon(:,1) = nodelist(1:end-1);
linecon(:,2) = nodelist(2:end);
