function le = do_le2D(linecon,Xgrid,Ygrid);
% usage: le = do_le2D(linecon,Xgrid,Ygrid)
% le          - list of element lengths
% linecon     - connectivity table
% Xgrid,Ygrid - global grid database
% given a connectivity table for linear basis line elements, and two
% dimensional nodal coordinate data, compute the length of each element
% and return this data as a column array

nelements = size(linecon,1);
le = zeros(nelements,1);		% reserve memory for le
% index into Xgrid and extract the x coordinates of each point referenced 
% in linecon.  The xcoords array will have the same shape as the linecon
% array
xcoords = Xgrid(linecon);
% compute the difference in x coordinates for each element
xdiff = xcoords(:,2) - xcoords(:,1);
% do the same for y coordinates
ycoords = Ygrid(linecon);
ydiff = ycoords(:,2) - ycoords(:,1);

le = sqrt(xdiff.*xdiff + ydiff.*ydiff);
