function   LAPe = do_laplacian_q0_hyper(ETAe,el_nodal_con_data)
% usage:  LAPe = do_laplacian_q0_hyper(ETAe,el_nodal_con_data)
% el_nodal_con_data is element nodal data used to contract the master
% element library hypermatrices.  el_nodal_con_dat must have dimensions
% of (npe x nelements), where npe is nodes per element and nelements is
% the total number of elements.

% Copywrite 2000 by Michael B. Taylor.
% Master element matrices calculated by Joe Orzacowsky.
% Thanks to Zac Chambers for bug fixes.

% check the arguments for consistantcy.
if size(ETAe,1)==4 & size(ETAe,2)==4 & size(ETAe,3)>=1,
  % dimensions of ETAe are reasonable
else
  error('Check the dimensions of ETAe.  It must be 4x4xnelements');
end
nelements = size(ETAe,3); % deduce number of elements from dimensions of ETAe
if size(el_nodal_con_data,1)==4 & ... 
           size(el_nodal_con_data,2)==nelements
  % dimensions are reasonable and consistant with dimensions of ETAe
else
  error(['el_con_data must be a 4xnelements array.', ...
	 'Number of elements is deduced by examining ETAe'];
end

B3011(:,1) = [3 -3 -1  1 -3  3  1 -1 -1  1  1 -1  1 -1 -1  1]'/24;
B3011(:,2) = [3 -3 -1  1 -3  3  1 -1 -1  1  1 -1  1 -1 -1  1]'/24;
B3011(:,3) = [1 -1 -1  1 -1  1  1 -1 -1  1  3 -3  1 -1 -3  3]'/24;
B3011(:,4) = [1 -1 -1  1 -1  1  1 -1 -1  1  3 -3  1 -1 -3  3]'/24;
      	        					     	 
B3012(:,1) = [4 -4 -2  2  2 -2 -1  1 -2  2  1 -1 -4  4  2 -2]'/36;
B3012(:,2) = [2 -2 -1  1  4 -4 -2  2 -4  4  2 -2 -2  2  1 -1]'/36;
B3012(:,3) = [1 -1 -2  2  2 -2 -4  4 -2  2  4 -4 -1  1  2 -2]'/36;
B3012(:,4) = [2 -2 -4  4  1 -1 -2  2 -1  1  2 -2 -2  2  4 -4]'/36;
      	        					     	 
B3021(:,1) = [4  2 -2 -4 -4 -2  2  4 -2 -1  1  2  2  1 -1 -2]'/36;
B3021(:,2) = [2  4 -4 -2 -2 -4  4  2 -1 -2  2  1  1  2 -2 -1]'/36;
B3021(:,3) = [1  2 -2 -1 -1 -2  2  1 -2 -4  4  2  2  4 -4 -2]'/36;
B3021(:,4) = [2  1 -1 -2 -2 -1  1  2 -4 -2  2  4  4  2 -2 -4]'/36;
      	        					     	 
B3022(:,1) = [3  1 -1 -3  1  1 -1 -1 -1 -1  1  1 -3 -1  1  3]'/24;
B3022(:,2) = [1  1 -1 -1  1  3 -3 -1 -1 -3  3  1 -1 -1  1  1]'/24;
B3022(:,3) = [1  1 -1 -1  1  3 -3 -1 -1 -3  3  1 -1 -1  1  1]'/24;
B3022(:,4) = [3  1 -1 -3  1  1 -1 -1 -1 -1  1  1 -3 -1  1  3]'/24;

% contract the master element library hypermatrices to form element
% matrices (in eta coordinate system).
B211e = B3011*el_nodal_con_data;
B221_B212e = (B3021+B312)*el_nodal_con_data;
B222e = B3022*el_nodal_con_data;

% deduce number of elements from dimensions of ETAe
nelements = size(ETAe,3);

ETAe = reshape(ETAe,4,nelements);
% The rows of ETAe are now [ETAe11; ETAe21; ETAe12; ETAe22]
ETAe11 = ETAe(1,:);
ETAe21 = ETAe(2,:);
ETAe12 = ETAe(3,:);
ETAe22 = ETAe(4,:);

onez = ones(16,1);			% a column of ones

% apply metric data
LAPe = B211e .* (onez * ETAe11.^2) ...	% B2XXe contribution
     + B222e .* (onez *ETAe21.^2) ...	% B2XXe contribution
     + 2*(B221e+B212e) .* (onez * (ETAe21.*ETAe12)) ... % cross terms
     + B211e .* (onez * ETAe12.^2) ...	% B2YYe contribution
     + B222e .* (onez *ETAe22.^2);	% B2YYe contribution

% reshape the results into nelements slices, where each slice is a
% 4x4 element matrix.
LAPe = reshape(LAPe,4,4,nelements);
