function LAPe = do_laplacian_q0(ETAe)
% usage:  LAPe = do_laplacian_q0(ETAe)
% Calculates element diffusion matrices for linear quad elements, no
% quadrature, modulo determinant and ke
%
% Copyright 2000 by Michael B. Taylor

% library matrices
% matrices are stored with columns stacked one upon the other.
B211 = [2 -2 -1  1 -2  2  1 -1 -1  1  2 -2  1 -1 -2  2]' / 6;
B212 = [1 -1 -1  1  1 -1 -1  1 -1  1  1 -1 -1  1  1 -1]' / 4;
B221 = [1  1 -1 -1 -1 -1  1  1 -1 -1  1  1  1  1 -1 -1]' / 4;
B222 = [2  1 -1 -2  1  2 -2 -1 -1 -2  2  1 -2 -1  1  2]' / 6;
 
% infer the number of elements from the ETAe data structure
nelements = size(ETAe,3);

ETAe = reshape(ETAe,4,nelements);
% The rows  of ETAe are now [ETAe11, ETAe21, ETAe12, ETAe22]
% Construct B2IIe using sums of outer products.
B2XXe =   B211 * ETAe(1,:).^2 ...
	+ (B221+B212) * (ETAe(1,:).*ETAe(2,:)) ...
	+ B222 * ETAe(2,:).^2; 

B2YYe =   B211 * ETAe(3,:).^2 ...
	+ (B221+B212) * (ETAe(3,:).*ETAe(4,:)) ...
	+ B222 * ETAe(4,:).^2; 

LAPe = B2XXe + B2YYe;
% reshape B2XXe into the required format
LAPe = reshape(LAPe,4,4,nelements);


