function [DETe,ZETAe]=do_ZETAe_2Dt(X,Y,TRI)
% usage: [DETe,ZETAe]=do_ZETAe_2Dt(X,Y,TRI)
% calculates det and dZETAi/dXj for linear triangle elements.
%
%  DETe -  element determinants (2*Ae)  
%  ZETAe - dZETAi/dXj, arranged in matrix form, modulo DETe.  ZETAe is a
%    3 dimensional matrix, with the third index of ZETAe corresponding to
%    the element numbeer
%  X,Y  -  arrays of nodal coordinates
%  TRI  -  Node connectivity table, produced from X and Y by the 
%           delaunay function.
%

% find the number of elements from the dimensions of TRI
nelements = size(TRI,1);

% Get the element coordinates by indexing into the global coordinates
Xe = X(TRI);
Ye = Y(TRI);

% calculate DETe
DETe =   Xe(:,2).*Ye(:,3) - Xe(:,3).*Ye(:,2) ...
       - Xe(:,1).*Ye(:,3) + Xe(:,3).*Ye(:,1) ...
       + Xe(:,1).*Ye(:,2) - Xe(:,2).*Ye(:,1);

% look for bad elements
bad_els = find(DETe<=0);
if isempty(bad_els)
  % good, no elements with negative or zero determinants
else
  error('negative det, try doing fliplr(TRI) before calling do_ZETA')
end

% calculate the ZETAs
ZETA11 = Ye(:,2) - Ye(:,3);
ZETA21 = Ye(:,3) - Ye(:,1);
ZETA31 = Ye(:,1) - Ye(:,2);
ZETA12 = Xe(:,3) - Xe(:,2);
ZETA22 = Xe(:,1) - Xe(:,3);
ZETA32 = Xe(:,2) - Xe(:,1);

% put ZETAs into final form
ZETAe = [ZETA11, ZETA21, ZETA31, ZETA12, ZETA22, ZETA32];
ZETAe = reshape(ZETAe',3,2,nelements);
