function LAPe=do_Laplacian_2Dt(ZETAe)
% usage: LAPe=do_Laplacian_2Dt(ZETAe)
% Calculates element diffusion matrices for linear triangle elements,
% modulo the determinant (2*Ae) and the element diffusion coefficient.
%
% ZETAe should be calculated prior to calling this routine 
% using do_ZETAe_2Dt.
%
% DIFFe is calculated as a 3 by 3 by nelements array, with the ith plane,
% DIFFe(:,:,i), corresponding to the ith element.
%
% Copyright 2000 by Michael B. Taylor

% put ZETAe into an easier to use form
nelements = size(ZETAe,3);
ZETAe = (reshape(ZETAe,6,nelements))';
% the columns of ZETAe are now
% ZETA11,ZETA21,ZETA31,ZETA21,ZETA22,ZETA32
ZETA11 = ZETAe(:,1);
ZETA21 = ZETAe(:,2);
ZETA31 = ZETAe(:,3);
ZETA12 = ZETAe(:,4);
ZETA22 = ZETAe(:,5);
ZETA32 = ZETAe(:,6);

% calculate the diffusion matrix
D11 = ZETA11.^2 + ZETA12.^2;
D21 = ZETA21 .* ZETA11 + ZETA22 .* ZETA12;
D31 = ZETA31 .* ZETA11 + ZETA32 .* ZETA12;
D12 = D21;
D22 = ZETA21.^2 + ZETA22.^2;
D32 = ZETA31 .* ZETA21 + ZETA32 .* ZETA22;
D13 = D31;
D23 = D32;
D33 = ZETA31.^2 + ZETA32.^2;

% Put the diffusion matrix into its final form
LAPe = 1/2 * [D11,D21,D31,D12,D22,D32,D13,D23,D33]';
LAPe = reshape(LAPe,3,3,nelements);
