function [DETe,ETAe]=do_ETAe_q0(X1,X2,elcon)
% usage:  [DETe,ETAe]=do_ETAe_q0(X1,X2,elcon)
% calculates det and dETAi/dXj for linear quad elements, no quadrature.
% ref:  Finite Elements 1-2-3
%
%  DETe -  column array of element determinants
%  ETAe -  dETAi/dXj, calculated by eq 6.44.  One 2x2 matrix per element.
%  X1, X2  -  arrays of nodal coordinates
%  elcon - Node connectivity table.  The nth row of elcon is an ordered list
%            of node numbers.  The corresponding nodes are the veritces of
%            the nth element.
%


% number of elements is equal to the number of rows of ELCON
nelements = size(elcon,1);

% make X1e and X2e.  These hold the nodal coordinates for each element,
% one row per element.
X1e = X1(elcon);
X2e = X2(elcon);
  
% calculate ETAe via eq 6.44
ETAe11 = (X2e(:,4)-X2e(:,1)+X2e(:,3)-X2e(:,2))/4;
ETAe21 = (X2e(:,2)-X2e(:,1)+X2e(:,3)-X2e(:,4))/4;
ETAe12 = (X1e(:,4)-X1e(:,1)+X1e(:,3)-X1e(:,2))/4;
ETAe22 = (X1e(:,2)-X1e(:,1)+X1e(:,3)-X1e(:,4))/4;

DETe = ETAe11 .* ETAe22 - ETAe12 .* ETAe21;

% make ETAe into a stack of 2x2 matrices, one slice for each element
ETAe = ([ETAe11, ETAe21, ETAe12, ETAe22])';
ETAe = reshape(ETAe,2,2,nelements);

% look for zero or negative determinants
bad_DETs = find(DETe <= 0);
if isempty(bad_DETs)
  % no problems
else
  % found some bad elements
  error('zero or negative element determinants')
end


