function  [B2XXe,B2YXe,B2XYe,B2YYe]= do_B2IIe_q0_hyper(ETAe,el_nodal_con_data)
% usage:  [B2XXe,B2YXe,B2XYe,B2YYe]= do_B2IIe_q0_hyper(ETAe,el_nodal_con_data)
% el_nodal_con_data is element nodal data used to contract the master
% element library hypermatrices.  el_nodal_con_dat must have dimensions
% of (npe x nelements), where npe is nodes per element and nelements is
% the total number of elements.

% Copywrite 2000 by Michael B. Taylor.
% Master element matrices calculated by Joe Orzacowsky.
% Thanks to Zac Chambers for bug fixes.

% check the arguments for consistantcy.
if size(ETAe,1)==2 & size(ETAe,2)==2 & size(ETAe,3)>=1,
  % dimensions of ETAe are reasonable
else
  error('Check the dimensions of ETAe.  It must be 2x2xnelements');
end
nelements = size(ETAe,3); % deduce number of elements from dimensions of ETAe
if size(el_nodal_con_data,1)==4 & ... 
           size(el_nodal_con_data,2)==nelements
  % dimensions are reasonable and consistant with dimensions of ETAe
else
  error(['el_con_data must be a 4xnelements array.', ...
	 'Number of elements is deduced by examining ETAe']);
end

B3011(:,1) = [3 -3 -1  1 -3  3  1 -1 -1  1  1 -1  1 -1 -1  1]'/24;
B3011(:,2) = [3 -3 -1  1 -3  3  1 -1 -1  1  1 -1  1 -1 -1  1]'/24;
B3011(:,3) = [1 -1 -1  1 -1  1  1 -1 -1  1  3 -3  1 -1 -3  3]'/24;
B3011(:,4) = [1 -1 -1  1 -1  1  1 -1 -1  1  3 -3  1 -1 -3  3]'/24;
      	        					     	 
B3012(:,1) = [4 -4 -2  2  2 -2 -1  1 -2  2  1 -1 -4  4  2 -2]'/36;
B3012(:,2) = [2 -2 -1  1  4 -4 -2  2 -4  4  2 -2 -2  2  1 -1]'/36;
B3012(:,3) = [1 -1 -2  2  2 -2 -4  4 -2  2  4 -4 -1  1  2 -2]'/36;
B3012(:,4) = [2 -2 -4  4  1 -1 -2  2 -1  1  2 -2 -2  2  4 -4]'/36;
      	        					     	 
B3021(:,1) = [4  2 -2 -4 -4 -2  2  4 -2 -1  1  2  2  1 -1 -2]'/36;
B3021(:,2) = [2  4 -4 -2 -2 -4  4  2 -1 -2  2  1  1  2 -2 -1]'/36;
B3021(:,3) = [1  2 -2 -1 -1 -2  2  1 -2 -4  4  2  2  4 -4 -2]'/36;
B3021(:,4) = [2  1 -1 -2 -2 -1  1  2 -4 -2  2  4  4  2 -2 -4]'/36;
      	        					     	 
B3022(:,1) = [3  1 -1 -3  1  1 -1 -1 -1 -1  1  1 -3 -1  1  3]'/24;
B3022(:,2) = [1  1 -1 -1  1  3 -3 -1 -1 -3  3  1 -1 -1  1  1]'/24;
B3022(:,3) = [1  1 -1 -1  1  3 -3 -1 -1 -3  3  1 -1 -1  1  1]'/24;
B3022(:,4) = [3  1 -1 -3  1  1 -1 -1 -1 -1  1  1 -3 -1  1  3]'/24;

% contract the master element library hypermatrices to form element
% matrices (in eta coordinate system).
B211e = B3011*el_nodal_con_data;
B221e = B3021*el_nodal_con_data;
B212e = B3012*el_nodal_con_data;
B222e = B3022*el_nodal_con_data;

ETAe = reshape(ETAe,4,nelements);
% The rows of ETAe are now [ETAe11; ETAe21; ETAe12; ETAe22]
ETAe11 = ETAe(1,:);
ETAe21 = ETAe(2,:);
ETAe12 = ETAe(3,:);
ETAe22 = ETAe(4,:);

onez = ones(16,1);			% a column of ones

% apply metric data to form B2XXe, ect.
B2XXe =   B211e .* (onez * ETAe11.^2) ...
	+ (B221e+B212e) .* (onez * (ETAe11.*ETAe21)) ...
        + B222e .* (onez *ETAe21.^2);

B2YXe =   B211e .* (onez * (ETAe12.*ETAe11)) ...
	+ B221e .* (onez * (ETAe22.*ETAe11)) ...
	+ B212e .* (onez * (ETAe12.*ETAe21)) ...
	+ B222e .* (onez * (ETAe22.*ETAe21));

B2XYe =   B211e .* (onez * (ETAe11.*ETAe11)) ...
	+ B221e .* (onez * (ETAe22.*ETAe11)) ...
	+ B212e .* (onez * (ETAe12.*ETAe21)) ...
	+ B222e .* (onez * (ETAe22.*ETAe21));

B2YYe =   B211e .* (onez * ETAe12.^2) ...
	+ (B221e+B212e) .* (onez * (ETAe21.*ETAe12)) ...
        + B222e .* (onez *ETAe22.^2);

% reshape the results into nelements slices, where each slice is a
% 4x4 element matrix.
B2XXe = reshape(B2XXe,4,4,nelements);
B2YXe = reshape(B2YXe,4,4,nelements);
B2XYe = reshape(B2XYe,4,4,nelements);
B2YYe = reshape(B2YYe,4,4,nelements);
