function [B2XXe,B2YXe,B2XYe,B2YYe] = do_B2IIe_q0(ETAe)
% usage:  [B2XXe,B2YXe,B2XYe,B2YYe] = do_B2IIe_q0(ETAe)
% Calculates element diffusion matrices for linear quad elements, no
% quadrature, modulo determinant and ke

% library matrices
% matrices are stored with columns stacked one upon the other.
B211 = [2 -2 -1  1 -2  2  1 -1 -1  1  2 -2  1 -1 -2  2]' / 6;
B212 = [1 -1 -1  1  1 -1 -1  1 -1  1  1 -1 -1  1  1 -1]' / 4;
B221 = [1  1 -1 -1 -1 -1  1  1 -1 -1  1  1  1  1 -1 -1]' / 4;
B222 = [2  1 -1 -2  1  2 -2 -1 -1 -2  2  1 -2 -1  1  2]' / 6;
 
% infer the number of elements from the ETAe data structure
nelements = size(ETAe,3);

ETAe = reshape(ETAe,4,nelements);
% The rows  of ETAe are now [ETAe11, ETAe21, ETAe12, ETAe22]
% Construct B2IIe using sums of outer products.
B2XXe =   B211 * ETAe(1,:).^2 ...
	+ (B221+B212) * (ETAe(1,:).*ETAe(2,:)) ...
	+ B222 * ETAe(2,:).^2; 

B2YYe =   B211 * ETAe(3,:).^2 ...
	+ (B221+B212) * (ETAe(3,:).*ETAe(4,:)) ...
	+ B222 * ETAe(4,:).^2;

B2YXe =   B211 * (ETAe(3,:) .* ETAe(1,:)) ...
	+ B221 * (ETAe(4,:) .* ETAe(1,:)) ...
	+ B212 * (ETAe(3,:) .* ETAe(2,:)) ...
	+ B222 * (ETAe(4,:) .* ETAe(2,:));

B2XYe =   B211 * (ETAe(1,:) .* ETAe(3,:)) ...
	+ B221 * (ETAe(2,:) .* ETAe(3,:)) ...
	+ B212 * (ETAe(1,:) .* ETAe(4,:)) ...
	+ B222 * (ETAe(2,:) .* ETAe(4,:));

% reshape B2XXe and B2YYe into the required format
B2XXe = reshape(B2XXe,4,4,nelements);
B2YYe = reshape(B2YYe,4,4,nelements);
B2YXe = reshape(B2YXe,4,4,nelements);
B2XYe = reshape(B2XYe,4,4,nelements);
