function [B2XXe,B2YXe,B2XYe,B2YYe]=do_B2IIe_2Dt(ZETAe)
% usage: [B2XXe,B2YXe,B2XYe,B2YYe]=do_B2IIe_2Dt(ZETAe)
% Calculates element diffusion matrices for linear triangle elements,
% modulo the determinant (2*Ae) and the element diffusion coefficient.
%
% ZETAe should be calculated prior to calling this routine 
% using do_ZETAe_2Dt.
%
% DIFFe is calculated as a 3 by 3 by nelements array, with the ith plane,
% DIFFe(:,:,i), corresponding to the ith element.

% put ZETAe into an easier to use form
nelements = size(ZETAe,3);
ZETAe = (reshape(ZETAe,6,nelements))';
% the columns of ZETAe are now
% ZETA11,ZETA21,ZETA31,ZETA21,ZETA22,ZETA32
ZETA11 = ZETAe(:,1);
ZETA21 = ZETAe(:,2);
ZETA31 = ZETAe(:,3);
ZETA12 = ZETAe(:,4);
ZETA22 = ZETAe(:,5);
ZETA32 = ZETAe(:,6);

% calculate the diffusion matrices
XX11 = ZETA11.^2;
XX21 = ZETA21 .* ZETA11;
XX31 = ZETA31 .* ZETA11;
XX12 = XX21;
XX22 = ZETA21.^2;
XX32 = ZETA31 .* ZETA21;
XX13 = XX31;
XX23 = XX32;
XX33 = ZETA31.^2;

YX11 = ZETA12.*ZETA11;
YX21 = ZETA22.*ZETA11;
YX31 = ZETA32.*ZETA11;
YX12 = ZETA12.*ZETA21;
YX22 = ZETA22.*ZETA21;
YX32 = ZETA32.*ZETA21;
YX13 = ZETA12.*ZETA31;
YX23 = ZETA22.*ZETA31;
YX33 = ZETA32.*ZETA31;

XY11 = YX11;
XY21 = YX12;
XY31 = YX13;
XY12 = YX21;
XY22 = YX22;
XY32 = YX23;
XY13 = YX31;
XY23 = YX32;
XY33 = YX33;

YY11 = ZETA12.^2;
YY21 = ZETA22 .* ZETA12;
YY31 = ZETA32 .* ZETA12;
YY12 = YY21;
YY22 = ZETA22.^2;
YY32 = ZETA32 .* ZETA22;
YY13 = YY31;
YY23 = YY32;
YY33 = ZETA32.^2;

% Put the diffusion matrices into final form
B2XXe = 1/2 * [XX11,XX21,XX31,XX12,XX22,XX32,XX13,XX23,XX33]';
B2XXe = reshape(B2XXe,3,3,nelements);

B2YXe = 1/2 * [YX11,YX21,YX31,YX12,YX22,YX32,YX13,YX23,YX33]';
B2YXe = reshape(B2YXe,3,3,nelements);

B2XYe = 1/2 * [XY11,XY21,XY31,XY12,XY22,XY32,XY13,XY23,XY33]';
B2XYe = reshape(B2XYe,3,3,nelements);

B2YYe = 1/2 * [YY11,YY21,YY31,YY12,YY22,YY32,YY13,YY23,YY33]';
B2YYe = reshape(B2YYe,3,3,nelements);
