function [B2X0e,B2Y0e] = do_B2I0e_q0(ETAe)
% usage:  [B2X0e,B2Y0e] = do_B2I0e_q0(ETAe)
% Calculates element convection  matrices for linear quad elements, no
% quadrature, modulo determinant 

% library matrices
B210 = 1/6 * [-2  2  1 -1 -2  2  1 -1 -1  1  2 -2 -1  1  2 -2]';
B220 = 1/6 * [-2 -1  1  2 -1 -2  2  1 -1 -2  2  1 -2 -1  1  2]';

% deduce number of elements from dimensions of ETAe
nelements = size(ETAe,3);

ETAe = reshape(ETAe,4,nelements);
% The rows of ETAe are now [ETAe11; ETAe21; ETAe12; ETAe22]

% Construct B2I0e as the sums of outer products.
B2X0e =   B210 * ETAe(1,:) + B220 * ETAe(2,:);
B2Y0e =   B210 * ETAe(3,:) + B220 * ETAe(4,:);

% reshape B20Ie into the required format
B2X0e = reshape(B2X0e,4,4,nelements);
B2Y0e = reshape(B2Y0e,4,4,nelements);
