function [B300Xe,B300Ye] = do_B20I_q0_hyper(ETAe)
% usage:  [B300Xe,B300Ye] = do_B20I_q0_hyper(ETAe)
% Calculates element convection  matrices for linear quad elements, no
% quadrature, modulo determinant 
% el_nodal_con_data is element nodal data used to contract the master
% element library hypermatrices.  el_nodal_con_dat must have dimensions
% of (npe x nelements), where npe is nodes per element and nelements is
% the total number of elements.

% Copywrite 2000 by Michael B. Taylor.
% Master element matrices calculated by Joe Orzechowski.

% check the arguments for consistantcy.
if size(ETAe,1)==4 & size(ETAe,2)==4 & size(ETAe,3)>=1,
  % dimensions of ETAe are reasonable
else
  error('Check the dimensions of ETAe.  It must be 4x4xnelements');
end
nelements = size(ETAe,3); % deduce number of elements from dimensions of ETAe
if size(el_nodal_con_data,1)==4 & ... 
           size(el_nodal_con_data,2)==nelements
  % dimensions are reasonable and consistant with dimensions of ETAe
else
  error(['el_con_data must be a 4xnelements array.', ...
	 'Number of elements is deduced by examining ETAe'];
end

% library matrices
B3001(:,1) = [-6 -3 -1 -2  6  3  1  2  2  1  1  2 -2 -1 -1 -2]'/36;
B3001(:,2) = [-3 -6 -2 -1  3  6  2  1  1  2  2  1 -1 -2 -2 -1]'/36;
B3001(:,3) = [-1 -2 -2 -1  1  2  2  1  1  2  6  3 -1 -2 -6 -3]'/36;
B3001(:,4) = [-2 -1 -1 -2  2  1  1  2  2  1  3  6 -2 -1 -3 -6]'/36;
      						      
B3002(:,1) = [-6 -2 -1 -3 -2 -2 -1 -1  2  2  1  1  6  2  1  3]'/36;
B3002(:,2) = [-2 -2 -1 -1 -2 -6 -3 -1  2  6  3  1  2  2  1  1]'/36;
B3002(:,3) = [-1 -1 -2 -2 -1 -3 -6 -2  1  3  6  2  1  1  2  2]'/36;
B3002(:,4) = [-3 -1 -2 -6 -1 -1 -2 -2  1  1  2  2  3  1  2  6]'/36;

% contract the master element library hypermatrices to form element
% matrices (in eta coordinate system).
B201e = B3001*el_nodal_con_data;
B202e = B3002*el_nodal_con_data;

ETAe = reshape(ETAe,4,nelements);
% The rows of ETAe are now [ETAe11; ETAe21; ETAe12; ETAe22]
ETAe11 = ETAe(1,:);
ETAe21 = ETAe(2,:);
ETAe12 = ETAe(3,:);
ETAe22 = ETAe(4,:);

onez = ones(16,1);			% a column of ones

B20Xe = B201e.*(onez*ETAe11) + B202e.*(onez*ETAe21);
B20Ye = B201e.*(onez*ETAe12) + B202e.*(onez*ETAe22);

% reshape the results into 4x4xnelements 3D matrices before returning
B20Xe = reshape(B20Xe,4,4,nelements);
B20Ye = reshape(B20Ye,4,4,nelements);
