function [B20Xe,B20Ye] = do_B20Ie_q0_2(ETAe)
% usage:  [B20Xe,B20Ye] = do_20I_q0(ETAe)
% Calculates element convection  matrices for linear quad elements, no
% quadrature, modulo determinant 

% library matrices
B201B = 1/6 *  [-2 2 1 -1; ...
		-2 2 1 -1; ...
		-1 1 2 -2; ...
		-1 1 2 -2];

B202B = 1/6 *  [-2 -1 1 2; ...
		-1 -2 2 1; ...
		-1 -2 2 1; ...
		-2 -1 1 2];

% deduce number of elements from dimensions of ETAe
nelements = size(ETAe,3);

ETAe = reshape(ETAe,4,nelements);
ETAe=ETAe';
% The columns of ETAe are now [ETAe11, ETAe21, ETAe12, ETAe22]

% Construct B20Ie as the sums of outer products.
B20Xe = ETAe(:,1) * B201B(:)' + ETAe(:,2) * B202B(:)';
B20Ye = ETAe(:,3) * B201B(:)' + ETAe(:,4) * B202B(:)';

% reshape B20Ie into the required format
B20Xe=B20Xe'; B20Ye=B20Ye';
B20Xe = reshape(B20Xe,4,4,nelements);
B20Ye = reshape(B20Ye,4,4,nelements);
