function [B20Xe,B20Ye] = do_B20Ie_q0(ETAe)
% usage:  [B20Xe,B20Ye] = do_20I_q0(ETAe)
% Calculates element convection  matrices for linear quad elements, no
% quadrature, modulo determinant 

% library matrices
B201B = 1/6 *  [-2 2 1 -1; ...
		-2 2 1 -1; ...
		-1 1 2 -2; ...
		-1 1 2 -2];

B202B = 1/6 *  [-2 -1 1 2; ...
		-1 -2 2 1; ...
		-1 -2 2 1; ...
		-2 -1 1 2];

% deduce number of elements from dimensions of ETAe
nelements = size(ETAe,3);

ETAe = reshape(ETAe,4,nelements);
% The rows of ETAe are now [ETAe11; ETAe21; ETAe12; ETAe22]

% Construct B20Ie as the sums of outer products.
B20Xe =   B201B(:) * ETAe(1,:) + B202B(:) * ETAe(2,:);
B20Ye =   B201B(:) * ETAe(3,:) + B202B(:) * ETAe(4,:);

% reshape B20Ie into the required format
B20Xe = reshape(B20Xe,4,4,nelements);
B20Ye = reshape(B20Ye,4,4,nelements);
