function [B20Xe, B20Ye]=do_B20I_2Dt(ZETAe)
% usage: [B20Xe, B20Ye]=do_B20I_2Dt(ZETAe)
% Calculates element advection matrices for linear triangle elements.
%
% ZETAe should be calculated prior to calling this routine 
% using do_ZETAe_2Dt.

% put ZETAe into an easier to use form
nelements = size(ZETAe,3);
ZETAe = (reshape(ZETAe,6,nelements))';
% the columns of ZETAe are now
% ZETA11,ZETA21,ZETA31,ZETA21,ZETA22,ZETA32
ZETA11 = ZETAe(:,1);
ZETA21 = ZETAe(:,2);
ZETA31 = ZETAe(:,3);
ZETA12 = ZETAe(:,4);
ZETA22 = ZETAe(:,5);
ZETA32 = ZETAe(:,6);

B20Xe = [ZETA11,ZETA11,ZETA11,ZETA21,ZETA21,ZETA21,ZETA31,ZETA31, ...
	ZETA31]/6;
B20Ye = [ZETA12,ZETA12,ZETA12,ZETA22,ZETA22,ZETA22,ZETA32,ZETA32, ...
	ZETA32]/6;

% put the results into final form
B20Xe = reshape(B20Xe',3,3,nelements);
B20Ye = reshape(B20Ye',3,3,nelements);
