/*
    UserSupport.h, Copyright 21.3.97 (c) by C. Conrad,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
 	PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/User/UserSupport.h,v $
 	Author(s):             C. Conrad 
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.12 $
 	Creation Date:         21.3.97
 	Last Date of Change:   $Date: 1999/12/13 21:48:43 $      by: $Author: ruf $
	
	
	$Log: UserSupport.h,v $
	Revision 1.12  1999/12/13 21:48:43  ruf
	GNU General Public Licence Update
	
	Revision 1.11  1998/04/09 12:16:44  fiedler
	*** empty log message ***
	
	Revision 1.10  1998/04/08 15:34:25  fiedler
	stringLength statt strlen

	Revision 1.9  1998/04/08 15:22:28  fiedler
	*** empty log message ***

	Revision 1.8  1998/04/03 15:33:41  fiedler
	kill, & , problems with getargument!

	Revision 1.7  1997/04/13 16:52:07  conrad
	Adding of itoa(), int2string() was not perfect (errors, ...)

 * Revision 1.6  1997/04/09  16:21:50  conrad
 * adding of an atoi() function
 *
 * Revision 1.5  1997/04/08  15:20:35  conrad
 * adding of stringCompare()
 *
 * Revision 1.4  1997/04/08  12:50:35  brunner
 * int2string and stringConcat added
 *
 * Revision 1.3  1997/04/08  12:49:58  brunner
 * *** empty log message ***
 *
 * Revision 1.2  1997/03/22  12:52:23  conrad
 * adding of "dummy" display()
 *
 * Revision 1.1  1997/03/21  19:13:30  conrad
 * Initial revision
 *
*/

#ifndef __USERSUPPORT_H
#define __USERSUPPORT_H

#include "../Topsy/Topsy.h"
 
#define MAXCOMMENTSIZE     70
#define EQUAL 1
#define BEFORE 2
#define AFTER 3
#define UNDEFINED -1


/*
 * Copy nbBytes from address srcAddress to address targetAddress.
 * (equivalent to UNIX memcpy(), new name to avoid confusion).
 */
void byteCopy( Address targetAddress,
               Address sourceAddress,
               unsigned long int nbBytes);

/* fill memory with zeros */
void zeroOut(Address target, unsigned long int size);

/* initialize mem with a constant char */
void initmem(Address target, unsigned long int size, char c);

/*
 * Copy a NULL-terminated string from source to target.
 * (equivalent to UNIX strcpy(), new name to avoid confusion).
 */
void stringCopy( char* target, char* source );

/* copies a string or at most the first size-1 bytes 
 * and terminates it with 0 
 */
void stringNCopy( char* target, char* source, unsigned long int size);

int stringLength( char* s);

/* concatenate source 1 and source2 into the string dest */
/* dest needs to bee big enough to contain both */
void stringConcat(char *dest, char *source1, char *source2);

/* translate an integer to a string */
void int2string(char *str, int i);

void display( ThreadId tty, char* s);

int stringCompare(char* a, char* b);
int stringNCompare(const char *s1, const char *s2, int n);

int power(int base, int n);

int atoi(int* intValue, char* string);

void reverse(char s[]);

void itoa(int n, char s[]);

#endif __USERSUPPORT_H
