/*
    UserSupport.c, Copyright 21.3.97 (c) by C. Conrad,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/User/UserSupport.c,v $
 	Author(s):             C. Conrad 
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.15 $
 	Creation Date:         21.3.97
 	Last Date of Change:   $Date: 1999/12/13 21:48:42 $      by: $Author: ruf $
	
	
	$Log: UserSupport.c,v $
	Revision 1.15  1999/12/13 21:48:42  ruf
	GNU General Public Licence Update
	
	Revision 1.14  1999/06/06 20:55:30  jeker
	putting everything together for Topsy 2.0
	
	Revision 1.13  1999/02/02 23:04:03  cjeker
	latest fixes

	Revision 1.12  1999/01/20 12:55:57  cjeker
	CR LF translation fix
	
	Revision 1.11  1999/01/14 19:24:08  cjeker
	'\n' -> '\n\r' translation is now done in display()
	
	Revision 1.10  1998/04/09 12:16:18  fiedler
	stringNCompare analog zu strncmp in libc
	
	Revision 1.9  1998/04/08 15:34:25  fiedler
	stringLength statt strlen

	Revision 1.8  1998/04/08 15:22:24  fiedler
	*** empty log message ***

	Revision 1.7  1998/04/03 15:33:41  fiedler
	kill, & , problems with getargument!

	Revision 1.6  1997/04/13 16:51:47  conrad
	Adding of itoa(), int2string() was not perfect (errors, ...)

 * Revision 1.5  1997/04/09  16:21:50  conrad
 * adding of an atoi() function
 *
 * Revision 1.4  1997/04/08  15:20:35  conrad
 * adding of stringCompare()
 *
 * Revision 1.3  1997/04/08  12:49:11  brunner
 * int2string and stringConcat added
 *
 * Revision 1.2  1997/03/22  12:52:23  conrad
 * adding of "dummy" display()
 *
 * Revision 1.1  1997/03/21  19:13:30  conrad
 * Initial revision
 *
*/

#include "UserSupport.h"
#include "Syscall.h"

void byteCopy( Address targetAddress,
               Address sourceAddress,
               unsigned long int nbBytes)
{
    char* src = (char*)sourceAddress;
    char* tar = (char*)targetAddress;
    unsigned long int i;
    
    for (i = 0; i < nbBytes; i++) {
        *tar++ = *src++;
    }
}
 
void zeroOut(Address target, unsigned long int size)
{
    char* tar = (char*)target;
    unsigned long int i;
    
    for (i = 0; i < size; i++) *tar++ = 0;
}

/* schneller als zeroOut */
void initmem(Address target, unsigned long int size, char c)
{
    char* tar = (char*)target;
    unsigned long int i;
    
    for (i=size; i>0; i--) *tar++ = c;
}
 
void stringCopy( char* target,
                 char* source)
{
    while ((*target++ = *source++) != '\0')
      ;
}
 
void stringNCopy(char* target, char* source, unsigned long int size)
{
    while (((*target++ = *source++) != '\0') && ((--size) > 1)) ;
    *target = '\0';
}

int stringLength( char* s)
{
    int len=0;

    if (s!=NULL)
      while (*s++ != '\0')
	len++;

    return len;
}



void stringConcat(char *dest, char *source1, char *source2)
{
    char *ptr;
    ptr = dest;
    stringCopy(ptr, source1);
    ptr+=stringLength(source1);
    stringCopy(ptr,source2);
}

void int2string(char *str, int i)
{
    int j,nrc;
    
    j=i;
    nrc=0;
    while(j>0) {
        nrc++;
        j = (j - (j%10))/10;
    }
    if (i < 0) {
        nrc++;
        str[0] = '-';
    }
    if (i == 0) str[0] = '0';
    str[nrc+1] = 0;
    while(nrc >0) {
        str[--nrc] = (i%10) + 48;
        i = (i - (i%10))/10;
    }
}

void display( ThreadId tty, char* s)
/* s is a pointer to a '\0' terminated string, tty is the output device */
{
    char tmp[82], *t = tmp;
    unsigned long int i;
    
    #define LF2CR_TRANS 1
    
    while ( LF2CR_TRANS ) {
    	/* Translate newlines into carriage returns plus newlines for
	 	 * correct terminal output
	 	 */
        for (i=0; i < 82-2 /* '\0' and perhaps the last '\r' */ && *s; i++) {
            *t++ = *s;
            if ( *s++ == '\n') {
                 *t++ = '\r'; i++;
            }
        }
        
        *t='\0';
        t-=i;
        ioWrite(tty, t, &i);
        if ( ! *s ) return;
    }
    i = (unsigned long int) stringLength(s);
    ioWrite(tty, s, &i );
}
    
int stringCompare(char* a, char* b) {
  int i = 0;
  if (a != NULL && b != NULL) {
    while ((a[i] != '\0') && (b[i] != '\0')) {
      if (a[i] < b[i]) return BEFORE;
      if (a[i] > b[i]) return AFTER;
      i++;
    }
    /* a contains b or vice versa */
    if (a[i] == '\0' && b[i] == '\0') return EQUAL;
    if (a[i] == '\0') return BEFORE;
    return AFTER;
  }
  return UNDEFINED;
}

int stringNCompare(const char *s1, const char *s2, int n) {

  if (n == 0 || s1 == NULL || s2 == NULL) return UNDEFINED;
  do {
    if (*s1 != *s2) {
      if (*s1 < *s2) return BEFORE;
      else return AFTER;
    }
    if (*s1 == 0 || *s2 == 0) break;
    s1++; s2++;
  } while (--n != 0 );
  if ((n == 0) || (*s1 == 0 && *s2 == 0))  return EQUAL;
  if (*s1 == 0) return BEFORE;
  return AFTER;
}

int power(int base, int n)
{
    int p;
    for (p=1;n>0;--n)
      p*=base;
    return p;
}


int atoi(int* intValue, char* string)
{
    char* currentPtr = string;
    int counter=0;
    int nbChars=1;
    
    *intValue=0;

    /* cur positioned on last byte not NULL */
    while (*(currentPtr+1) != '\0') {
	counter++;
	currentPtr++;
	nbChars++;
    }
    
    while (counter>=0) {
	if ( *currentPtr=='-') {
	    if (counter==0) {
		*intValue *= (-1);
	    } else {
		return -1;
	    }
	} else {
	    if ( *currentPtr-'0' < 0 || *currentPtr-'0' > 9) {
		return -1;
	    }
	    *intValue+=(*currentPtr-'0')*(power(10,nbChars-counter-1));
	}
	counter--;
	currentPtr--;
    }
    return 1;
}

void reverse(char s[])
{
    int c,i,j;
    for(i=0,j=stringLength(s)-1;i<j;i++,j--) {
	c=s[i];
	s[i]=s[j];
	s[j]=c;
    }
}
void itoa(int n, char s[])
{
    int i, sign;

    if ((sign = n) < 0)
      n = -n;
    i=0;
    do {
	s[i++]=n%10+'0';
    } while ((n/=10)>0);
    if (sign<0)
      s[i++]='-';
    s[i]='\0';
    reverse(s);
}

/*void byteCopy( Address targetAddress,
               Address sourceAddress,
               unsigned long int nbBytes)
{
    char* src = (char*)sourceAddress;
    char* tar = (char*)targetAddress;
    unsigned long int i;
    
    for (i = 0; i < nbBytes; i++) {
        *tar++ = *src++;
    }
}*/
