/*
    ThreadsDemo.c, Copyright  (c) by ,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/User/ThreadsDemo.c,v $
 	Author(s):             
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.3 $
 	Creation Date:         
 	Last Date of Change:   $Date: 1999/12/13 21:48:42 $      by: $Author: ruf $
	
	
	$Log: ThreadsDemo.c,v $
	Revision 1.3  1999/12/13 21:48:42  ruf
	GNU General Public Licence Update
	
	Revision 1.2  1998/04/07 17:04:07  fiedler
	new file
	
*/

#include "../Topsy/Syscall.h"
#include "UserSupport.h"

void Child() {
	Message sendmsg;
	ThreadId console, myid, parentid;

	ioOpen(IO_CONSOLE, &console);
	ioInit(console);
	display(console, "child started\n");
	
	tmGetInfo(SELF, &myid, &parentid);
	tmMsgSend(parentid, &sendmsg);

	display(console, "child running\n");
}

void Demo() {
	ThreadId console, child;
	Message reply;
	
	ioOpen(IO_CONSOLE, &console);
	ioInit(console);
	display(console, "parent started\n");
	
	tmStart(&child, (ThreadMainFunction)Child, (ThreadArg)0, "child");

	display(console, "parent running\n");
	
	if (tmMsgRecv(&child, ANYMSGTYPE, &reply, INFINITY) == TM_MSGRECVOK) {
		display(console, "parent received message from child\n");
	}

	display(console, "parent continuing\n");

	if (tmMsgRecv(&child, ANYMSGTYPE, &reply, INFINITY) == TM_MSGRECVFAILED) {
		display(console, "exit of child\n");
	}
}
