/*
    Shell.h, Copyright  (c) by George Fankhauser,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/User/Shell.h,v $
 	Author(s):             George Fankhauser
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.9 $
 	Creation Date:         
 	Last Date of Change:   $Date: 1999/12/13 21:48:42 $      by: $Author: ruf $
	
	
	$Log: Shell.h,v $
	Revision 1.9  1999/12/13 21:48:42  ruf
	GNU General Public Licence Update
	
	Revision 1.8  1999/04/08 11:40:21  jeker
	added some new files, modified some others for unix port
	
	Revision 1.7  1999/01/14 19:24:35  cjeker
	pre2.0 release

	Revision 1.6  1998/04/08 08:27:30  fiedler
	*** empty log message ***
	
	Revision 1.5  1998/04/07 15:21:53  fiedler
	add Demo.[ch]

	Revision 1.4  1998/04/03 15:33:41  fiedler
	kill, & , problems with getargument!

	Revision 1.3  1997/04/23 11:56:10  gfa
	removed prog0

 * Revision 1.2  1997/04/04  20:04:20  gfa
 * introduced the NULL command (an empty newline pressed at the console)
 *
 * Revision 1.1  1997/03/26  16:11:37  conrad
 * Initial revision
 *
 * Revision 1.3  1997/03/23  10:46:49  gfa
 * *** empty log message ***
 *
 * Revision 1.2  97/03/23  10:43:37  gfa
 * first hack (demo bp)
 * 
 * Revision 1.1  97/03/21  21:34:32  gfa
 * Initial revision
 * 
*/
#ifndef __SHELL_H__
#define __SHELL_H__

#include "Topsy.h"
#include "Syscall.h"

typedef struct ShellFunction_t {
    char* name;
    ThreadMainFunction function;
    ThreadArg arg;
} ShellFunction;

    
#define SHELL_INVALID	0
#define SHELL_START	1
#define SHELL_EXIT	2
#define SHELL_KILL	3
#define SHELL_INFO	4
#define SHELL_HELP	5
#define SHELL_PS	6
#define SHELL_NULL	7

#define BACKGRCOMMAND       '&'

char* commandNames[] = {
	"invalid command\n", 
	"start", "exit", "kill", "info", "help", "ps", "\n"
};

#define WELCOME "\nTopsy Shell pre2.0 (c) 1998, ETH Zurich, TIK\n($Id: Shell.h,v 1.9 1999/12/13 21:48:42 ruf Exp $)\n\n"
#define EXITMESSAGE "exiting shell...\n"
#define PROMPT "> "
#define HELP "\
    start <function> <arg>   start a new thread\n\
    exit                     leave this shell  \n\
    kill <id>                kill a thread     \n\
    ps                       print thread status\n\
    help                     show this helptext\n" 

void main(ThreadArg arg);

#endif

