/*
    SeatReservation.c, Copyright 8.4.97 (c) by Marcus Brunner,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/User/SeatReservation.c,v $
 	Author(s):             Marcus Brunner 
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.13 $
 	Creation Date:         8.4.97
 	Last Date of Change:   $Date: 1999/12/13 21:48:42 $      by: $Author: ruf $
	
	
	$Log: SeatReservation.c,v $
	Revision 1.13  1999/12/13 21:48:42  ruf
	GNU General Public Licence Update
	
	Revision 1.12  1999/10/31 14:42:49  jeker
	first fixes for SimOS
	
	Revision 1.11  1999/05/26 10:28:33  jeker
	Bug Fix, sum was used uninitalised

	Revision 1.10  1998/04/15 08:37:23  gfa
	small version for web demo

 * Revision 1.9  98/03/26  20:38:36  gfa
 * added changes for tmGetInfo
 * 
	Revision 1.8  1997/04/25 06:47:17  brunner
	type cast added in tmStart Arguments

 * Revision 1.7  1997/04/23  14:11:36  brunner
 * *** empty log message ***
 *
 * Revision 1.5  1997/04/23  11:51:01  brunner
 * *** empty log message ***
 *
 * Revision 1.4  1997/04/17  12:55:14  brunner
 * *** empty log message ***
 *
 * Revision 1.2  1997/04/08  13:11:32  conrad
 * change tmStart interface
 *
 * Revision 1.1  1997/04/08  12:48:14  brunner
 * Initial revision
 *

*/

#include "../Topsy/Syscall.h"
#include "UserSupport.h"
 
#define MAX_SEATS 30
#define NR_THREADS  5

int seats;                   /* Anzahl reservierter Sitze */
ThreadId tty;                /* ThreadId des I/O Thread */
int reisebuero[NR_THREADS];  /* Zwischenergebnisse der Buchungen */
int k;   

void Res_Thread(int i)
{
    int myreserved,tmp,j;
    char str[10],output[40],output2[40],idstr[7];
    ThreadId myid, parent;
    Message reply;
    Boolean full;
    
    /* Hole eigene ThreadId */
    if (tmGetInfo(SELF, &myid, &parent) < 0) {
        display(tty,"tmGetInfo failed\n");
        return;
    }    
    /* initalisieren der Variabeln */
    myreserved = 0;
    itoa(myid,idstr);
    stringConcat(idstr,idstr,": ");
    full =FALSE;
    
    /* Falls noch Sitze vorhanden sind, reservere einen Sitz */
    while (!full) {
        /* lesen der Anzahl bis jetzt reservierten Sitze */
        tmp = seats;
        
        /* for demonstration only , extension of critical region */
        for (j=0; j<2300; j++) {
             k--;
        }
        
        /* Sind noch Sitze frei ? */
        if (tmp >= MAX_SEATS) {
            /* Nein, ausgebucht */
            itoa(myreserved,str);
            stringConcat(output,idstr,str);
            stringConcat(output2,output," Sitze total erhalten\n");
            display (tty,output2);

	    /* Abbruch */            
            full = TRUE;
        }
        else {
            /* Ja, es hat noch freie */
            /* erhoehe die Anzahl der Sitze, welche dieses Reisebuero
               reserviert hat
            */
            myreserved++;
            
            /* Schreibe die neue Anzahl der Sitze zurueck */
            seats = tmp+1;
            
            /* print */
            itoa(tmp,str);
            stringConcat(output,idstr,str);
            stringConcat(output2,output," Sitze sind schon reserviert\n");
            display (tty,output2);
        }
    }
    /* Speichere die Sitze, die diese Reisebuero reserviert hat */
    reisebuero[i] = myreserved;
}

void Start_Reservation()
{
    ThreadId child[NR_THREADS];
    Message reply;
    int i,sum;
    char str[10];
    
    ioOpen(IO_CONSOLE, &tty);
    ioInit(tty);    
    
    seats = 0;
    sum = 0;
    
    /* Reisebueros werden kreiert */
    for (i=0; i< NR_THREADS; i++){
        if (tmStart( &child[i], (ThreadMainFunction)Res_Thread, (ThreadArg)i ,"Res_Thread") == TM_STARTFAILED) {
             display(tty,"thread start failed");
        }  
    }

    /* Wir warten, bis alle Reisebueros fertig gebucht haben */
    for (i=0; i<  NR_THREADS; i++){
        if (tmMsgRecv(&(child[i]), ANYMSGTYPE, &reply, INFINITY) == TM_MSGRECVFAILED) {
            /* Receive failed, weil der Thread child[i] nicht mehr existiert */
        }
    }
    
    display(tty,"Alle Reisebueros haben geschlossen\n");    
    
    for (i=0; i<  NR_THREADS; i++){
        sum +=reisebuero[i];
    }
            
    /* Alle Reisebueros haben geschlossen */
    itoa(sum,str);
    display(tty,"Die Reisebuero's haben zusammen ");
    display(tty,str);
    display(tty," Sitze reserviert \n(Es stehen 30 zur Verfuegung)\n");
}
