/*
    PacketStackGlobals.h, Copyright 1.4.97 (c) by Bernard Stauffer,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
  File:          $Source: /usr/drwho/vault/cvs/topsy/Topsy/User/PacketStackGlobals.h,v $
  Author(s):         Bernard Stauffer 
  Affiliation:       ETH Zuerich, TIK
  Version:         $Revision: 1.4 $
  Creation Date:       1.4.97
  Last Date of Change:   $Date: 1999/12/13 21:48:41 $    by: $Author: ruf $
  
  
*/


#ifndef _packetstack_globals
#define _packetstack_globals



/* Constants */

#define MAXPACKETLEN  256

                                  /* Used as indices for My_ThreadList */
#define TTY_ID        0           /* Driver threads (Kernel) */
#define DRIVER_ID     1
#define CONTROL_ID    2           /* User threads */
#define SENDER_ID     3
#define RECEIVER_ID   4
#define IRQSEND_ID    7
#define IRQRECV_ID    8
#define FRAMER_ID     5
#define DEFRAMER_ID   6
#define IRQTIMER_ID   9

#define THREAD_COUNT  10



/* Vars */

ThreadId  My_ThreadList[THREAD_COUNT];    /* List of all used thread id's */

volatile Boolean    packetStartFlag;      /* HAS TO BE VOLATILE !!!!! */

unsigned long TimerEnable;



#endif

