/*
    PacketFraming.c, Copyright 1.5.97 (c) by Bernard Stauffer,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
  
  File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/User/PacketFraming.c,v $
  Author(s):             Bernard Stauffer 
  Affiliation:           ETH Zuerich, TIK
  Version:               $Revision: 1.7 $
  Creation Date:         1.5.97
  Last Date of Change:   $Date: 1999/12/13 21:48:41 $      by: $Author: ruf $
*/  


#include "../Topsy/Topsy.h"
#include "../Topsy/Syscall.h"
#include "UserSupport.h"

#include "PacketStackGlobals.h"
#include "PacketFraming.h"

#define DATALINKESCAPE '\\'
#define BEGINOFPACKET '['
#define ENDOFPACKET ']'

/* -------------------------------------------------------------------------------------- */
/* Framer thread: receives packets from the IRQ thread and marks beginning of each packet */
/* with character sequence '|[` and ending of each packet with '|]'. Stuffing of character*/
/* '\\' within the packets */

void PacketFramer() {

  Message         putmsg, putmsg_ack;
  ThreadId        from;                       /* included for IRQControl */
  char            *ptrbuffer;
  char            beginofpacket = BEGINOFPACKET;
  char            endofpacket = ENDOFPACKET;
  char            datalinkescape = DATALINKESCAPE;
  unsigned long   buffersize, one, i;


  /* to be done by students */

}


/* ---------------------------------------------------------------------------- */
/* Deframer thread: gets packets from the IO driver and packetize the stream.   */

void PacketDeframer() {

  Message         getmsg, getmsg_ack;
  char            driverbuffer[MAXPACKETLEN], packetbuffer[MAXPACKETLEN];
  unsigned long   pos_driverbuffer, pos_packetbuffer, packetbuffersize, readlen;
  Boolean         packet_assembled, dle_detected;
  
  /* to be done by students */

}

/* ---------------------------------------------------------------------------- */
