/*
    PacketDriverTest.c, Copyright 1.5.97 (c) by Bernard Stauffer,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
  File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/User/PacketDriverTest.c,v $
  Author(s):             Bernard Stauffer 
  Affiliation:           ETH Zuerich, TIK
  Version:               $Revision: 1.6 $
  Creation Date:         1.5.97
  Last Date of Change:   $Date: 1999/12/13 21:48:41 $      by: $Author: ruf $
  
*/


#include "../Topsy/Topsy.h"
#include "../Topsy/Syscall.h"
#include "../IO/IOConsole.h"
#include "UserSupport.h"
#include "PacketDriverTest.h"




/* ---------------------------------------------------------------------------- */
/* A simple test programm, which helps you to debug your driver. A string is    */
/* sent to the driver and expected to be received. Some 'display'-functions     */
/* are included to enabled fast debugging.                                      */

void PacketDriverTest() {

  char                fromNet[25], s[5];
  ThreadId            tty, driver;
  unsigned long int   sizelen1, sizelen2, read_bytes, total_bytes; 

  char hello1[] = "\nTest PacketDriver\n";
  char hello2[] = "\nHello World over FPGA\n";


  sizelen1 = stringLength(hello1);
  sizelen2 = stringLength(hello2);

  ioOpen(IO_CONSOLE, &tty);
  ioInit(tty);
  ioOpen(IO_FPGA_COMM, &driver);
  ioInit(driver);

                      /* Writing the welcome message to console */
  ioWrite(tty, hello1, &sizelen1);

                      /* Writing the message to the net */
  if (ioWrite(driver, hello2, &sizelen2) == IO_WRITEFAILED) {
    display(tty,"ioWrite failed");
  }
  else {
    display(tty,"\nMessage sent to FPGA. Waiting to receive ...\n");
    read_bytes = 25;
    total_bytes = 0;
    while (total_bytes != sizelen2) {       /* Receiving the message from the net */
      if (ioRead(driver, fromNet, &read_bytes) == IO_READFAILED) {
        display(tty,"ioRead failed");
        read_bytes = 0;
      }
      else {
        total_bytes = total_bytes + read_bytes;   /* Count the received bytes */
        itoa(read_bytes, s);
        display(tty,s);
        display(tty," bytes received.\n");
      }
    }
                      /* Writing the received message to console */
    ioWrite(tty, fromNet, &total_bytes);

  }

}
