/*
    IRQControl.h, Copyright 1.4.97 (c) by Milan Tadjan,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
  
  File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/User/IRQControl.h,v $
  Author(s):             Milan Tadjan 
  Affiliation:           ETH Zuerich, TIK
  Version:               $Revision: 1.5 $
  Creation Date:         1.4.97
  Last Date of Change:   $Date: 1999/12/13 21:48:41 $      by: $Author: ruf $
  
  
*/

#define MAXLEN 256
#define ACK '\x06'
#define NACK '\x15'
#define MAX_ERROR_COUNT 10
#define DATAPACKET 2
#define ACKPACKET 3

void IRQ_Send();

void IRQ_Receive();

void IRQ_Timer();

unsigned long CheckCrc(unsigned char buf[]);
unsigned long CheckSeqNr(unsigned long i,unsigned long j);
unsigned long GetSeqNumber(unsigned char *Buf);
unsigned long crc(unsigned char *buf);
unsigned long GetEventId(Message msg);
void BuildIframe(unsigned char *s,unsigned long SequenceNr,unsigned long PacketType);
void CopyBuf(unsigned char *s, unsigned char t[],unsigned long offset,unsigned long length);
void ShiftBuf(unsigned char *s,unsigned long shift,unsigned long packetlength);
void irqInit(unsigned long *ErrorCount,unsigned long *RetxCount,unsigned long *Vs,unsigned long *PresentState,unsigned long *WaitTime);
void ackInit(unsigned char ack[]);
void StopTimer();

/*   Variable   */

/* unsigned int CRCDIV = 0xC180; */
