/*
    HelloWorld.c, Copyright 1.4.97 (c) by Marcus Brunner,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/User/HelloWorld.c,v $
 	Author(s):             Marcus Brunner 
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.4 $
 	Creation Date:         1.4.97
 	Last Date of Change:   $Date: 1999/12/13 21:48:41 $      by: $Author: ruf $
	
	
	$Log: HelloWorld.c,v $
	Revision 1.4  1999/12/13 21:48:41  ruf
	GNU General Public Licence Update
	
	Revision 1.3  1999/02/02 23:04:03  cjeker
	latest fixes
	
	Revision 1.2  1998/04/07 17:03:42  fiedler
	new version for exercise 1
	
	Revision 1.1  1997/04/02 10:24:54  brunner
	Initial revision

*/

#include "../Topsy/Syscall.h"
#include "UserSupport.h"

void Hello() {
    ThreadId console;
    unsigned long int size;
    char hello[] = "Hello World\n\r";

    size = sizeof(hello);
    ioOpen(IO_CONSOLE, &console);
    ioInit(console);
    ioWrite(console, hello, &size);
    ioClose(console);
}
