/*
    Exception.h, Copyright  (c) by George Fankhauser,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	Initial revision

*/
#ifndef _EXCEPTION_H_
#define _EXCEPTION_H_

// a direct include (vs. Unix.h) is used here in order to not 
// poison user process' name space 
#include <signal.h>

/* unix processes don't feature hardware interrupts */
typedef enum { bla } InterruptId;

/* unix process exceptions/signals 
 */
typedef enum {
	ALARM        = SIGALRM,
	SEND         = SIGUSR1,
	RECV         = SIGUSR2,

	ADDRESSERROR = SIGSEGV,
	BUSERROR     = SIGBUS,
	
	INTERRUPTSIGNAL = SIGINT,
	RESERVEDINSTRUCTION = SIGILL
} ExceptionId;

#endif
