/*
    SyscallMsg.S, Copyright  (c) by Eckart Zitzler, Christian Conrad,,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Topsy/mips/SyscallMsg.S,v $
 	Author(s):             Eckart Zitzler, Christian Conrad, George Fankhauser
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.18 $
 	Creation Date:         
 	Last Date of Change:   $Date: 1999/12/13 21:48:39 $      by: $Author: ruf $
	
	
	$Log: SyscallMsg.S,v $
	Revision 1.18  1999/12/13 21:48:39  ruf
	GNU General Public Licence Update
	
	Revision 1.17  1997/04/04 18:23:25  gfa
	replaced all k0/k1/at register references with t0/t1 in functions
	that do not run in exceptions (these registers are not saved on
	context switches and that's why they're called kernel scratch).
	
# Revision 1.16  1997/04/04  09:21:00  gfa
# *** empty log message ***
#
# Revision 1.15  97/03/19  21:43:38  conrad
# corrected bug (forgot to dereference a0 after syscall !)
# 
# Revision 1.14  1997/03/14  10:48:25  conrad
# Dereferencing of first argument in tmMsgRecv (was a bug !)
#
# Revision 1.13  1997/03/13  23:57:29  gfa
# *** empty log message ***
#
# Revision 1.12  1997/03/13  14:29:35  conrad
# As user code has no access onto kernel code, it was not possible to reset the
# flag just after the syscall, this has to be done in the kernel during scheduling
# decision
#
# Revision 1.11  1997/03/12  17:55:44  conrad
# debugging version
#
# Revision 1.10  1997/03/10  11:22:02  conrad
# cosmetics
#
# Revision 1.9  1997/03/04  16:57:13  conrad
# *** empty log message ***
#
# Revision 1.8  1997/02/28  14:09:07  gfa
# added #define SYSCALL_SEND_OP/SYSCALL_RECV_OP
#
# Revision 1.7  1997/02/26  17:35:40  conrad
# cleaning
#
# Revision 1.6  1997/02/25  17:00:54  conrad
# re-setting of msgPendingFlag to FALSE
#
# Revision 1.5  1997/02/24  21:36:00  conrad
# incomplete version
#
# Revision 1.4  1997/02/21  16:54:15  conrad
# very incomplete status due to major changes ...
#
# Revision 1.3  1997/02/21  09:17:57  conrad
# Adding of a new parameter to tmMsgRecv()
#
# Revision 1.2  1997/02/19  17:48:18  conrad
# *** empty log message ***
#
# Revision 1.1  1997/02/13  16:24:46  gfa
# Initial revision
#
# Revision 1.1  1997/02/13  15:49:14  conrad
# Initial revision
#
 * Revision 1.4  1997/02/13  07:49:33  conrad
 * Syscalls for thread management added
 *
 * Revision 1.3  1997/02/12  13:02:00  zitzler
 * kernel syscalls for memory management added
 *
 * Revision 1.2  1997/02/12  10:32:43  zitzler
 * memory manager syscalls only
 *
 * Revision 1.1  1997/02/04  11:46:04  topsy
 * Initial revision
 *
*/


#define SYSCALL_SEND_OP      0
#define SYSCALL_RECV_OP      1
#define MESSAGEFROM_OFFSET   0
  
#include "asm.h"

    .text
    .align 2

    /* Basic mechanismus for sending messages (SYSCALL exception),
     * Argument registers are:
     *     a0: destination thread (ThreadId)
     *     a1: message reference (Message *msg)
     */
  
    NESTED(tmMsgSend, 32, ra)
	sw         a0, 0(a1)        /* dest. thread put into msg from field */
	li         a3, SYSCALL_SEND_OP
    
	/* Argument registers are now:
	    a0: - (undefined)
	    a1: message reference (Message*) (destination thread id included)
	    a2: - (undefined)
	    a3: SYSCALL_SEND_OP
	*/
	
	syscall          /* Raising of an exception (trap to kernel mode) */
    
	/* The return value of tmMsgSend() is in v0 is it was stored 
	 * the senders context in msgDispatcher 
	 */
    ENDNESTED(tmMsgSend, 32)



    /* Basic mechanismus for receiving messages (SYSCALL exception),
	Argument registers are:
	    a0: expected thread id (ThreadId*)
	    a1: expected message type (MessageId)
	    a2: message reference (Message*)
	    a3: timeout (int milliseconds)
    */
    NESTED(tmMsgRecv, 32, ra)
        lw         t0, 0(a0)     /* dereference a0 -> t0 */
        sw         t0, 0(a2)     /* threadId (t0) copied into from field */
        sw         a1, 4(a2)     /* msgId (a1) copied into id field of msg */
        move       a1, a2        /* shifting of arguments */
        move       a2, a3        /* shifting of arguments */
        li         a3, SYSCALL_RECV_OP
        
        /* Argument registers are now:
              a0: - (undefined) (actually unchanged)
              a1: message reference (Message*)
              a2: timeout (unsigned long int)
              a3: SYSCALL_RECV_OP
        */

        syscall               /* Raising of an exception (trap) */

        /* from field of tmMsgRecv() is set with msgPtr->from */
        lw         t0, MESSAGEFROM_OFFSET(a1)
        sw         t0, 0(a0)

        /* The return value of tmMsgRecv() is in v0 */
    ENDNESTED(tmMsgRecv, 32)



