/*
    SupportAsm.S, Copyright  (c) by George Fankhauser,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
        
        File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Topsy/mips/SupportAsm.S,v $
        Author(s):             George Fankhauser
        Affiliation:           ETH Zuerich, TIK
        Version:               $Revision: 1.9 $
        Creation Date:         
        Last Date of Change:   $Date: 1999/12/13 21:48:39 $      by: $Author: ruf $
        
        
        $Log: SupportAsm.S,v $
        Revision 1.9  1999/12/13 21:48:39  ruf
        GNU General Public Licence Update

        Revision 1.8  1999/10/23 19:07:18  jeker
        added Makefile.SimOS.mips and did some code cleanup

        Revision 1.7  1999/10/23 14:19:49  jeker
        first cleanup for R4k support

        Revision 1.6  1999/10/22 19:22:44  gfa
        *** empty log message ***

        Revision 1.5  1998/04/08 15:09:29  gfa
        added getEPC, getBADVM

        Revision 1.4  1998/04/07 15:32:32  gfa
        getCP0reg

        Revision 1.3  1997/04/04 18:22:48  gfa
        replaced all k0/k1/at register references with t0/t1 in functions
        that do not run in exceptions (these registers are not saved on
        context switches and that's why they're called kernel scratch).

# Revision 1.2  1997/03/27  14:13:39  gfa
# *** empty log message ***
#
# Revision 1.1  1997/03/18  13:13:33  gfa
# Initial revision
#
*/

#include "asm.h"
#include "cpu.h"

        .text
        .align 2

        FRAME(testAndSet)

	.set noreorder
		
	mfc0	t0, c0_status
	mtc0	zero, c0_status
	nop			/* interrupts disabled */
	
	lw	t1, 0(a0)	/* load lockVariable contents */
	move	v0, zero	/* prepare return FALSE in load delay */
	bnez	t1, lockIsAlreadySet
	nop
	addiu	v0, 1		/* return TRUE (successful locking) */
	sw	v0, 0(a0)	/* write back locked value */
lockIsAlreadySet:
	mtc0	t0, c0_status	/* re-enable interrupts */	
	
	.set reorder
	
        END(testAndSet)

	FRAME(getEPC)

	.set noreorder

	mfc0	v0, c0_epc 
	nop

	.set reorder

	END(getEPC)

        FRAME(getBADVM)

        .set noreorder

        mfc0    v0, c0_badvm
        nop

        .set reorder

	END(getBADVM)

        FRAME(getPRID)

        .set noreorder

        mfc0    v0, c0_prid
        nop

        .set reorder

        END(getPRID)

