/*
    PrintReg.c, Copyright 1999 (c) by Claudio Jeker,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
        
        File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Topsy/mips/PrintReg.c,v $
        Author(s):             Claudio Jeker
        Affiliation:           ETH Zuerich, TIK
        Version:               $Revision: 1.3 $
        Creation Date:         1999/04/08
        Last Date of Change:   $Date: 1999/12/13 21:48:39 $      by: $Author: ruf $
        
        
        $Log: PrintReg.c,v $
        Revision 1.3  1999/12/13 21:48:39  ruf
        GNU General Public Licence Update

        Revision 1.2  1999/05/13 17:06:03  jeker
        Initial revision

        Revision 1.1  1999/04/08 11:40:18  jeker
        added some new files, modified some others for unix port

*/

#include "IO.h"
#include "TMHal.h"
#include "SupportMIPS.h"
#include "TMScheduler.h"

void printRegisters()
{
    Register epc, badvm;

    epc = getEPC();
    badvm = getBADVM();
    ioConsolePutString("*** EPC:");
    ioConsolePutHexInt(epc);
    ioConsolePutString("  BADVM:");
    ioConsolePutHexInt(badvm);
    ioConsolePutString("\n");
}

