/*
    Limits.h, Copyright  (c) by ,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
        
        File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Topsy/mips/Limits.h,v $
        Author(s):             
        Affiliation:           ETH Zuerich, TIK
        Version:               $Revision: 1.2 $
        Creation Date:         
        Last Date of Change:   $Date: 1999/12/13 21:48:39 $      by: $Author: ruf $
        
        
        $Log: Limits.h,v $
        Revision 1.2  1999/12/13 21:48:39  ruf
        GNU General Public Licence Update

        Revision 1.1  1998/06/08 20:07:01  gfa
        Initial revision

        Revision 1.3  1998/06/08 19:41:58  gfa
        changed to ULONG_MAX (unix compatibility)

        Revision 1.2  1997/04/12 16:01:46  gfa
        fixed copy paste bug for U_LONG_MAX...

 * Revision 1.1  1997/03/15  18:18:37  gfa
 * Initial revision
 *
*/

/* compiler and target machine dependent limits */

#define CHAR_BIT 8
#define SCHAR_MIN (-128)
#define SCHAR_MAX 127
#define UCHAR_MAX 255U

#define CHAR_MIN 0
#define CHAR_MAX UCHAR_MAX

#define SHORT_MIN (-32768)
#define SHORT_MAX 32767
#define UNSIGNED_SHORT_MAX 65535U

#define INT_MAX 2147483647
#define INT_MIN (-INT_MAX-1)
#define UNSIGNED_INT_MAX 4294967295U

#define LONG_MIN INT_MIN
#define LONG_MAX INT_MAX
#define ULONG_MAX UNSIGNED_INT_MAX
