/*
    Exception.h, Copyright  (c) by George Fankhauser,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Topsy/mips/Exception.h,v $
 	Author(s):             George Fankhauser
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.4 $
 	Creation Date:         
 	Last Date of Change:   $Date: 2000/04/05 12:04:58 $      by: $Author: gfa $
	
	
	$Log: Exception.h,v $
	Revision 1.4  2000/04/05 12:04:58  gfa
	*** empty log message ***
	
	Revision 1.3  1999/12/13 21:48:39  ruf
	GNU General Public Licence Update
	
	Revision 1.2  1997/04/23 11:55:28  gfa
	cleanup
	
 * Revision 1.1  1997/04/09  07:46:42  conrad
 * Initial revision
 *
 * Revision 1.2  1997/04/07  10:08:06  gfa
 * removed functions again...
 *
 * Revision 1.1  1997/04/06  17:01:46  gfa
 * Initial revision
 *
 * Revision 1.4  1997/03/27  13:55:58  conrad
 * *** empty log message ***
 *
 * Revision 1.3  1997/03/12  18:52:59  gfa
 * *** empty log message ***
 *
 * Revision 1.2  1997/02/12  07:13:50  conrad
 * Adding of exception_UTLB with offset 32
 *
 * Revision 1.1  1997/02/04  11:45:49  topsy
 * Initial revision
 *
*/
#ifndef _EXCEPTION_H_
#define _EXCEPTION_H_


typedef enum { CLOCKINT_0 = 0,
	       CLOCKINT_1 = 1,
               ETHERTAPINT = 2,
	       CENTRONICSINT = 3,
	       FPGA_CARDINT = 4,
	       DUARTINT = 5,
	       SWINT_0 = 6,
	       SWINT_1 = 7
} InterruptId;

/* R3000 defined exceptions (range from 0 to 31) 
 */
typedef enum { HARDWARE_INT,
	       TLB_MOD,
	       TLB_LOAD,
	       TLB_STORE,
	       ADDR_ERR_LOAD, 
	       ADDR_ERR_STORE,
	       BUSERR_INSTR,
	       BUSERR_DATA,
	       SYSCALL, 
	       BREAKPOINT,
	       RES_INSTR,
	       CP_UNUSABLE,
	       OVERFLOW, 
	       UTLB_MISS = 32 
} ExceptionId;

#endif
