/*
    cpu.h, Copyright  (c) by Lukas Ruf, lr@lpr.ch,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Topsy/ia32/cpu.h,v $
 	Author(s):             Lukas Ruf, lr@lpr.ch
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.2 $
 	Creation Date:         
 	Last Date of Change:   $Date: 1999/12/13 21:48:38 $      by: $Author: ruf $
	
	
	$Log: cpu.h,v $
	Revision 1.2  1999/12/13 21:48:38  ruf
	GNU General Public Licence Update
	
	Revision 1.1  1999/05/13 17:06:01  jeker
	Initial revision
	
*/

#ifndef __CPU_H__
#define __CPU_H__

/* CoreLoad.h is included to make RM Addresses available to kernel:
      Load Address of:
      - Kernel
      - User
      - Driver (if so :-}) */
#include "CoreLoad.h"

#define PHYS_BASE     0
#define KUSEG_BASE    0x00100000  /* 1MB */
#define KUSEG_SIZE    0x07F00000  /* 127MB RAM is managed for init */
#define K1SEG_BASE    0x00000000  /* @0000: i386-specific Data Region   */ 
#define K1SEG_SIZE    0x00020000  /* 128KB: Ctrl Data Region */
#define K0SEG_BASE    0x00020000  /* @128KB:Kernel Code and Data */
#define K0SEG_SIZE    0x00080000  /* 512KB: Kernel Space */
#define K2SEG_BASE    0x000A0000  /* @640KB: Hardware IO Region */
#define K2SEG_SIZE    0x00060000  /* 360KB: */ 
                                  /* User Address relative to Kernel Data Segment */
#define UADDR_BASE    (KUSEG_BASE - K0SEG_BASE)

#define UADDR_START   0x40        /* define the user start address right after
                                     the binary file header: 64B for binary file
                                     information should be enough, I hope */
                                  /* User Load Address relative to Kernel Data Segment */
#define ULOAD_ADDR    ((USERSEG * 16) + USEROFS - K0SEG_BASE)
                                  /* Driver Load Address relative to Kernel Data Segment */
#define DLOAD_ADDR    ((DRIVSEG * 16) + DRIVOFS - K0SEG_BASE)

/*
#define ISA_KUSEG(x)    ((unsigned)(x)  >= KUSEG_BASE)
#define ISA_K0SEG(x)    (((unsigned)(x) >= K0SEG_BASE) && \
         ((unsigned)(x) <  K2SEG_BASE))
#define ISA_K1SEG(x)    (((unsigned)(x) >= K1SEG_BASE) && \
         ((unsigned)(x) <  K0SEG_BASE))
#define ISA_K2SEG(x)    ((unsigned)(x)  >= K2SEG_BASE) && \
         ((unsigned)(x) <  KUSEG_BASE))


#define K0SEG_TO_PHYS(x)  ((unsigned)(x) + K0SEG_BASE) 
#define PHYS_TO_K0SEG(x)  ((unsigned)(x) - K0SEG_BASE)

#define K1SEG_TO_PHYS(x)  ((unsigned)(x) + K1SEG_BASE)
#define PHYS_TO_K1SEG(x)  ((unsigned)(x) - K1SEG_BASE)

#define K0SEG_TO_K1SEG(x) ((unsigned)(x) + K0SEG_BASE)
#define K1SEG_TO_K0SEG(x) ((unsigned)(x) - K0SEG_BASE)
*/

#define U_TO_K(x)         ((unsigned)(x)  + UADDR_BASE)
#define K_TO_U(x)         ((unsigned)(x)  - UADDR_BASE)

#define PAGEBOUNDARY(x)   ((((x) >> 12) + 1) << 12)
  
#endif



