/*
    asm.h, Copyright  (c) by Lukas Ruf, lr@lpr.ch,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Topsy/ia32/asm.h,v $
 	Author(s):             Lukas Ruf, lr@lpr.ch
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.2 $
 	Creation Date:         
 	Last Date of Change:   $Date: 1999/12/13 21:48:38 $      by: $Author: ruf $
	
	
	$Log: asm.h,v $
	Revision 1.2  1999/12/13 21:48:38  ruf
	GNU General Public Licence Update
	
	Revision 1.1  1999/05/13 17:06:01  jeker
	Initial revision
	
*/

// ************************************************************************** //
// Copyrights (c) 1998 Lukas Ruf                                              //
// ************************************************************************** //
//                                                                            //
// ************************************************************************** //
#ifndef _ASM_H_
#define _ASM_H_ 

  #define   MARKER "TOPSYi386"

  #define   SYSCALL \
            int $0x30 

  #define   ENTER pushl %ebp; movl  %esp,%ebp
            
  #define   LEAVE movl  %ebp,%esp;  popl  %ebp ; ret

  #define FRAME(_name_)   \
            .align 4 ; \
            .globl _name_ ; \
            _name_:

                        
  /* Define some Parameters for Argument passing c->assembler */
  #define ARG1      0x08(%ebp)
  #define ARG2      0x0C(%ebp)
  #define ARG3      0x10(%ebp)
  #define ARG4      0x14(%ebp)
  #define ARG5      0x18(%ebp)
  #define ARG6      0x1C(%ebp)
                        
  // Positions of TSS Entries:
  // *************************
  #define _LINKTSS  0x00
  #define _ESP0     0x04
  #define _SS0      0x08
  #define _ESP1     0x0C
  #define _SS1      0x10
  #define _ESP2     0x14
  #define _SS2      0x18
  #define _CR3      0x1C
  #define _EIP      0x20
  #define _EFLAGS   0x24
  #define _EAX      0x28
  #define _ECX      0x2C
  #define _EDX      0x30
  #define _EBX      0x34
  #define _ESP      0x38
  #define _EBP      0x3C
  #define _ESI      0x40
  #define _EDI      0x44
  #define _ES       0x48
  #define _CS       0x4C
  #define _SS       0x50
  #define _DS       0x54
  #define _FS       0x58
  #define _GS       0x5C
  #define _LDT      0x60
  #define _DEBUGbit 0x64
  #define _IOBASE   0x66
                    
#endif




