/*
    Tools.c, Copyright  (c) by Lukas Ruf, lr@lpr.ch,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Topsy/ia32/Tools.c,v $
 	Author(s):             Lukas Ruf, lr@lpr.ch
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.2 $
 	Creation Date:         
 	Last Date of Change:   $Date: 1999/12/13 21:48:38 $      by: $Author: ruf $
	
	
	$Log: Tools.c,v $
	Revision 1.2  1999/12/13 21:48:38  ruf
	GNU General Public Licence Update
	
	Revision 1.1  1999/05/13 17:06:00  jeker
	Initial revision
	
*/

int strlen(char * ps)
  {
    int xret = 0;
    if (ps) while (ps[xret]) xret++;
    return xret;
  }

/* strncmp(char *p1, char *p2, int pl); 
   return values:
    p1 == p2 : 0
    p1 <  p2 : < 0
    p2 >  p2 : > 0
 */ 
char strncmp(char *p1, char *p2, int pl) {
  char xret = 0;
  int i = 0;
  if (p1 && p2) {
    while (!xret && p1[i] && p2[i] && pl) {
      xret = p1[i] - p2[i];
      i--;
      pl--;
    }
    if (!xret)
      if (pl)     /* have we reached end of one ? string */
        if (p1[i] && !p2[i])
          xret = 1;
        else 
          if (!p1[i] && p2[i])
            xret = -1;
  }
  return xret;
} 

char sign(int pi)
  {
    char xret = 0;
    if (pi < 0) xret = -1;
    if (pi > 0) xret =  1;
    return xret;
  }
  
void itoa(int pi, char *pstr) {
  char tmp[17];
  int ti = pi * sign(pi);
  int di = 10, i = 0, j = 0;
  if (ti > 0)
    while (((i < 11) && (ti)) || (i==0)) {
      tmp[i++] = ti % di + '0';
      ti /= di;
    }
  else
    tmp[i++] = '0';
  i--;  
  if (pi < 0) pstr[j++] = '-';
  for (; i >= 0; i--) pstr[j++] = tmp[i];
  pstr[j] = 0;
  return;
}
  
void itoal(int pi, char *pstr, unsigned char plength)
  {
    int i;
    itoa(pi,pstr);
    i = strlen(pstr);
    if (plength > i) {
      pstr[plength] = 0;
      for (;(plength > 0);) {
        pstr[--plength] = ' ';
        if (i > 0) pstr[plength] = pstr[--i];
      }
    }
    return;
  }

void itoah(int pi, char *pstr) {
  char hex[0x11] = "0123456789ABCDEF";
  char tmp[11]; 
  int i = 0, j = 0;
  if (pi > 0)
    while (pi > 0) {
      tmp[i++] = hex[pi % 0x10];
      pi = pi >> 4;
    }
  else 
    tmp[i++] = '0';
  tmp[i] = 0;
  for (;(i);) 
    pstr[j++] = tmp[--i];
  pstr[j] = 0;
  return; 
} 

void itoahl(int pi, char *pstr, unsigned char plength)
  {
    int i;
    itoah(pi,pstr);
    i = strlen(pstr);
    if (plength > i) {
      pstr[plength] = 0;
      for (;(plength > 0);) {
        pstr[--plength] = '0';
        if (i > 0) pstr[plength] = pstr[--i];
      }
    }
    return;
  }

/* expect at least ps[9] = '\0' */
void itob(char b, char *ps) {
  int i; char c = 1;
  for (i = 0; i < 8; i++) ps[i] = '0';
  if (ps)
  for (i = 7; (i >= 0); i--) {
    ps[i] = '0';
    if (b & c) ps[i] = '1';
    c *= 2;
  }
  ps[8] = 0;
}

int BCDtoBIN(int pBCD) {
  int xret = 0, xmul = 1;     
  while (pBCD) {
    xret += (pBCD & 0xF) * xmul;
    xmul *= 10;
    pBCD  = pBCD >> 4;
  }
  return xret;
}





