/*
    SupportAsm.h, Copyright  (c) by Lukas Ruf, lr@lpr.ch,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Topsy/ia32/SupportAsm.h,v $
 	Author(s):             Lukas Ruf, lr@lpr.ch
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.3 $
 	Creation Date:         
 	Last Date of Change:   $Date: 2000/06/06 12:03:23 $      by: $Author: ruf $
	
	
	$Log: SupportAsm.h,v $
	Revision 1.3  2000/06/06 12:03:23  ruf
	SupportAsm.h
	
	Revision 1.2  1999/12/13 21:48:38  ruf
	GNU General Public Licence Update
	
	Revision 1.1  1999/05/13 17:05:58  jeker
	Initial revision
	
*/

#ifndef __SUPPORTASM_H__
#define __SUPPORTASM_H__


#define cli   \
  asm ("cli") 
#define sti   \
  asm ("sti") 
  
void  __reboot();
void  __reset_TLB();
void  __wait();
void  __beep();
void  __outb(unsigned char pbyte, unsigned short pport);
void  __outw(unsigned short pword, unsigned short pport);
void  __outl(unsigned int pdword, unsigned short pport);
unsigned char __inb(unsigned short pport);
unsigned short __inw(unsigned short pport);
unsigned int __inl(unsigned short pport);

/* mutex.S */
unsigned char __mutex(void *p32mutex, unsigned long pmutexNr);
unsigned char __demutex(void *p32mutex, unsigned long pmutexNr);

/* start.S */
unsigned long   __getTextSize();
unsigned long   __getDataSize();

#endif



