/*
    Exception.h, Copyright  (c) by Lukas Ruf, lr@lpr.ch,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Topsy/ia32/Exception.h,v $
 	Author(s):             Lukas Ruf, lr@lpr.ch
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.2 $
 	Creation Date:         
 	Last Date of Change:   $Date: 1999/12/13 21:48:38 $      by: $Author: ruf $
	
	
	$Log: Exception.h,v $
	Revision 1.2  1999/12/13 21:48:38  ruf
	GNU General Public Licence Update
	
	Revision 1.1  1999/05/13 17:05:57  jeker
	Initial revision
	
*/

#ifndef _INTERRUPT_H_
#define _INTERRUPT_H_

/* Exception Constants.
 */

        #define T_Ex_00         0x00   /* Divide Error  -- division by zero         */
        #define T_Ex_01         0x01   /* Debug Exception                           */
        #define T_Ex_02         0x02   /* Nonmaskable Interrupt                     */
        #define T_Ex_03         0x03   /* Breakpoint (one byte INT 3 Instruction)   */
        #define T_Ex_04         0x04   /* Overflow (INTO)                           */
        #define T_Ex_05         0x05   /* Bounds check (BOUND)                      */
        #define T_Ex_06         0x06   /* Invalid Opcode                            */
        #define T_Ex_07         0x07   /* Coprocessor not available                 */
        #define T_Ex_08         0x08   /* Double fault (Error Code)                 */
        #define T_Ex_09         0x09   /* reserved                                  */
        #define T_Ex_0A         0x0A   /* Invalid TSS (Error Code)                  */
        #define T_Ex_0B         0x0B   /* Segment not present (Error Code)          */
        #define T_Ex_0C         0x0C   /* Stack exception (Error Code)              */
        #define T_Ex_0D         0x0D   /* General Protection (Error Code)           */
        #define T_Ex_0E         0x0E   /* Page Fault (Error Code)                   */
        #define T_Ex_0F         0x0F   /* reserved                                  */
        #define T_Ex_10         0x10   /* Coprocessor error                         */
        #define T_Ex_11         0x11   /* Alignment check (Error Code)              */
        #define T_Ex_12         0x12   /* Machine check (Error Code)                */

        #define T_Ex_13         0x13   /* reserved                                  */
        #define T_Ex_14         0x14   /* reserved                                  */
        #define T_Ex_15         0x15   /* reserved                                  */
        #define T_Ex_16         0x16   /* reserved                                  */
        #define T_Ex_17         0x17   /* reserved                                  */
        #define T_Ex_18         0x18   /* reserved                                  */
        #define T_Ex_19         0x19   /* reserved                                  */
        #define T_Ex_1A         0x1A   /* reserved                                  */
        #define T_Ex_1B         0x1B   /* reserved                                  */
        #define T_Ex_1C         0x1C   /* reserved                                  */
        #define T_Ex_1D         0x1D   /* reserved                                  */
        #define T_Ex_1E         0x1E   /* reserved                                  */
        #define T_Ex_1F         0x1F   /* reserved                                  */

/* Interrupt Constants.
 */

        #define T_IR_00         0x20     /*   0x20  Timer                  */
        #define T_IR_01         0x21     /*   0x21  Keyboard               */
        #define T_IR_02         0x22     /*   0x22  Slave IC               */
        #define T_IR_03         0x23     /*   0x23  Serial Port II         */
        #define T_IR_04         0x24     /*   0x24  Serial Port I          */
        #define T_IR_05         0x25     /*   0x25  Parallel Port II       */
        #define T_IR_06         0x26     /*   0x26  Floppy                 */
        #define T_IR_07         0x27     /*   0x27  Parallel Port I        */
        #define T_IR_08         0x28     /*   0x28  RTC                    */
        #define T_IR_09         0x29     /*   0x29  avail.                 */
        #define T_IR_0A         0x2A     /*   0x2A  avail.                 */
        #define T_IR_0B         0x2B     /*   0x2B  avail.                 */
        #define T_IR_0C         0x2C     /*   0x2C  avail.                 */
        #define T_IR_0D         0x2D     /*   0x2D  CoProcessor            */
        #define T_IR_0E         0x2E     /*   0x2E  Harddisk Controller    */
        #define T_IR_0F         0x2F     /*   0x2F  reserved               */

        #define T_IS_30         0x30     /*   0x30  SYSCALL :-)            */
        #define T_IS_31         0x31     /*   0x30  SYSCALL :-)            */


#ifndef __SASM__

  /* i386 defined exceptions (range from 0 to 31)
   */
  typedef enum {
          AEX_00 = T_Ex_00,     /*   0x00    Divide Error  -- division by zero         */
          AEX_01 = T_Ex_01,     /*   0x01    Debug Exception                           */
          AEX_02 = T_Ex_02,     /*   0x02    Nonmaskable Interrupt                     */
          AEX_03 = T_Ex_03,     /*   0x03    Breakpoint (one byte INT 3 Instruction)   */
          AEX_04 = T_Ex_04,     /*   0x04    Overflow (INTO)                           */
          AEX_05 = T_Ex_05,     /*   0x05    Bounds check (BOUND)                      */
          AEX_06 = T_Ex_06,     /*   0x06    Invalid Opcode                            */
          AEX_07 = T_Ex_07,     /*   0x07    Coprocessor not available                 */
          AEX_08 = T_Ex_08,     /*   0x08    Double fault (Error Code)                 */
          AEX_09 = T_Ex_09,     /*   0x09    reserved                                  */
          AEX_0A = T_Ex_0A,     /*   0x0A    Invalid TSS (Error Code)                  */
          AEX_0B = T_Ex_0B,     /*   0x0B    Segment not present (Error Code)          */
          AEX_0C = T_Ex_0C,     /*   0x0C    Stack exception (Error Code)              */
          AEX_0D = T_Ex_0D,     /*   0x0D    General Protection (Error Code)           */
          AEX_0E = T_Ex_0E,     /*   0x0E    Page Fault (Error Code)                   */
          AEX_0F = T_Ex_0F,     /*   0x0F    reserved                                  */
          AEX_10 = T_Ex_10,     /*   0x10    Coprocessor error                         */
          AEX_11 = T_Ex_11,     /*   0x11    Alignment check (Error Code)              */
          AEX_12 = T_Ex_12,     /*   0x12    Machine check (Error Code)                */

          AEX_13 = T_Ex_13,     /*   0x13    reserved                                  */
          AEX_14 = T_Ex_14,     /*   0x14    reserved                                  */
          AEX_15 = T_Ex_15,     /*   0x15    reserved                                  */
          AEX_16 = T_Ex_16,     /*   0x16    reserved                                  */
          AEX_17 = T_Ex_17,     /*   0x17    reserved                                  */
          AEX_18 = T_Ex_18,     /*   0x18    reserved                                  */
          AEX_19 = T_Ex_19,     /*   0x19    reserved                                  */
          AEX_1A = T_Ex_1A,     /*   0x1A    reserved                                  */
          AEX_1B = T_Ex_1B,     /*   0x1B    reserved                                  */
          AEX_1C = T_Ex_1C,     /*   0x1C    reserved                                  */
          AEX_1D = T_Ex_1D,     /*   0x1D    reserved                                  */
          AEX_1E = T_Ex_1E,     /*   0x1E    reserved                                  */
          AEX_1F = T_Ex_1F      /*   0x1F    reserved                                  */
  } ExceptionId;

  /* i386 defined 16 IRQs (range from 0x20 to 0x2F)
     Topsy i386 defined 1 SYSCALL residing at 0x30 !!!
   */

  typedef enum {
          AIR_00 = T_IR_00,    /*   0x20  Timer                  */
          AIR_01 = T_IR_01,    /*   0x21  Keyboard               */
          AIR_02 = T_IR_02,    /*   0x22  Slave IC               */
          AIR_03 = T_IR_03,    /*   0x23  Serial Port II         */
          AIR_04 = T_IR_04,    /*   0x24  Serial Port I          */
          AIR_05 = T_IR_05,    /*   0x25  Parallel Port II       */
          AIR_06 = T_IR_06,    /*   0x26  Floppy                 */
          AIR_07 = T_IR_07,    /*   0x27  Parallel Port I        */
          AIR_08 = T_IR_08,    /*   0x28  RTC                    */
          AIR_09 = T_IR_09,    /*   0x29  avail.                 */
          AIR_0A = T_IR_0A,    /*   0x2A  avail.                 */
          AIR_0B = T_IR_0B,    /*   0x2B  avail.                 */
          AIR_0C = T_IR_0C,    /*   0x2C  avail.                 */
          AIR_0D = T_IR_0D,    /*   0x2D  CoProcessor            */
          AIR_0E = T_IR_0E,    /*   0x2E  Harddisk Controller    */
          AIR_0F = T_IR_0F,    /*   0x2F  reserved               */
          AIS_30 = T_IS_30     /*   0x30  SYSCALL :-)            */
  } InterruptId;

  void ExceptionInit();
  void InterruptInit();
  /* __SASM__ */
#endif 
  
  /* _INTERRUPT_H_ */
#endif



