/*
    CoreLoad.h, Copyright  (c) by Lukas Ruf, lr@lpr.ch,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Topsy/ia32/CoreLoad.h,v $
 	Author(s):             Lukas Ruf, lr@lpr.ch
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.2 $
 	Creation Date:         
 	Last Date of Change:   $Date: 1999/12/13 21:48:37 $      by: $Author: ruf $
	
	
	$Log: CoreLoad.h,v $
	Revision 1.2  1999/12/13 21:48:37  ruf
	GNU General Public Licence Update
	
	Revision 1.1  1999/05/13 17:05:56  jeker
	Initial revision
	
*/

#ifndef __CORELOAD_H__
#define __CORELOAD_H__

;//////
;//// Load Address of CoreBoot (RM)
;//////
#define       BOOTSEG               0x0000 
#define       BOOTOFS               0x7C00 

#define       BOOTHead              0x0000 
#define       BOOTTrack             0x0000 
#define       BOOTSector            0x0001 

;//////
;//// Load Address of CoreLoad (RM)
;//////
#define       LOADSEG               0x4000
#define       LOADOFS               0x0000 

#define       LOADHead              0x0000 
#define       LOADTrack             0x0001 
#define       LOADSector            0x0001 

;//////
;//// Load Address of Kernel (RM)
;//////
;// KERNEL
;//////
#define       KERNSEG               0x2000    
#define       KERNOFS               0x0000    

#define       KERNHead              0x0000 
#define       KERNTrack             0x0002 
#define       KERNSector            0x0001 

;//////
;//// Load Address of Driver (RM)
;//////
;// DRIVER
;//////
#define       DRIVSEG               0x4000     
#define       DRIVOFS               0x0000    

#define       DRIVHead              0x0000 
#define       DRIVTrack             0x0009 
#define       DRIVSector            0x0001 

;//////
;//// Load Address of User (RM)
;//////
;// USER
;//////
#define       USERSEG               0x6000    
#define       USEROFS               0x0000    

#define       USERHead              0x0000 
#define       USERTrack             0x0010 
#define       USERSector            0x0001 

#endif



