/*
    Topsy.h, Copyright  (c) by Eckart Zitzler,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Topsy/Topsy.h,v $
 	Author(s):             Eckart Zitzler
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.12 $
 	Creation Date:         
 	Last Date of Change:   $Date: 1999/12/13 21:48:37 $      by: $Author: ruf $
	
	
	$Log: Topsy.h,v $
	Revision 1.12  1999/12/13 21:48:37  ruf
	GNU General Public Licence Update
	
	Revision 1.11  1997/04/07 10:19:28  gfa
	removed procedur
	ThreadMainFunction.
	
 * Revision 1.10  97/03/23  12:38:30  gfa
 * no changes
 * 
 * Revision 1.9  97/03/16  22:19:30  gfa
 * *** empty log message ***
 * 
 * Revision 1.8  1997/03/10  09:13:49  conrad
 * Adding of HMTHREADID for Heap Manager ThreadId
 *
 * Revision 1.7  1997/02/23  18:35:40  gfa
 * added IO_THREADID for io syscalls
 *
 * Revision 1.6  1997/02/17  16:27:12  conrad
 * New type ThreadMainFunction defined to replace void(*function)(void)
 *
 * Revision 1.5  1997/02/14  11:29:08  zitzler
 * ThreadArg type added
 *
 * Revision 1.4  1997/02/13  15:49:14  conrad
 * First compilation/linking of complete environment (all modules)
 *
 * Revision 1.3  1997/02/12  16:27:37  zitzler
 * component type deleted
 *
 * Revision 1.2  1997/02/12  10:33:38  zitzler
 * types Boolean, Register, Address, Error, Component
 *
 * Revision 1.1  1997/02/04  11:46:04  topsy
 * Initial revision
 *
*/

#ifndef _TOPSY_H_
#define _TOPSY_H_

#define MMTHREADID  -1     /* Memory Manager Thread Id. */
#define TMTHREADID  -2     /* Thread Manager Thread Id. */
#define IOTHREADID  -3     /* Input/Output Manager Thread Id. */

#define NULL (void*) 0

typedef enum {FALSE = 0, TRUE}  Boolean;

typedef void*  Address;

typedef long int Error;

typedef unsigned long int Register;

typedef long int ThreadId;       /* Kernel threads: < 0, User threads: > 1 */

typedef void* ThreadArg;
typedef void(*ThreadMainFunction)(ThreadArg);

#endif

