/*
    Syscall.h, Copyright  (c) by Eckart Zitzler, Christian Conrad, George Fankhauser,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Topsy/Syscall.h,v $
 	Author(s):             Eckart Zitzler, Christian Conrad, George Fankhauser
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.21 $
 	Creation Date:         
 	Last Date of Change:   $Date: 2000/04/03 17:45:31 $      by: $Author: gfa $
	
	
	$Log: Syscall.h,v $
	Revision 1.21  2000/04/03 17:45:31  gfa
	*** empty log message ***
	
	Revision 1.20  1999/12/13 21:48:37  ruf
	GNU General Public Licence Update
	
	Revision 1.19  1999/01/07 16:15:55  cjeker
	removed lightWeight Threads and added new syscall tmGetIDInfo
	
	Revision 1.18  1998/06/05 14:38:37  gfa
	changes for get/set time
	
	Revision 1.17  1998/03/26 20:34:37  gfa
	added tmGetFirst and tmGetNext

	Revision 1.16  1997/04/18 18:53:05  gfa
	fixed wrong parameter type in ioClose

 * Revision 1.15  1997/04/08  13:04:47  conrad
 * Change of syscall tmStart()
 *
 * Revision 1.14  1997/04/06  18:46:27  gfa
 * added vmCleanup syscall
 *
 * Revision 1.13  1997/03/28  12:08:46  gfa
 * added tmGetInfo syscall, types and constants
 *
 * Revision 1.12  1997/03/24  20:31:58  gfa
 * removed all traces of hmAlloc/Free...
 *
 * Revision 1.11  1997/03/22  14:30:12  conrad
 * locks replace msg for heap
 *
 * Revision 1.10  1997/03/16  22:13:26  gfa
 * *** empty log message ***
 *
 * Revision 1.9  1997/03/11  08:17:33  gfa
 * renamed km calls to hm...
 *
 * Revision 1.8  1997/03/09  20:51:55  gfa
 * *** empty log message ***
 *
 * Revision 1.7  1997/02/23  18:35:03  gfa
 * added io syscalls interface and implementation
 *
 * Revision 1.6  1997/02/21  09:16:43  conrad
 * Adding of the msgId parameter to tmMsgRecv()
 *
 * Revision 1.5  1997/02/17  16:26:03  conrad
 * Type ThreadMainFunction used instead of void(*function)(void) in
 * tmThreadStart (first argument).
 *
 * Revision 1.4  1997/02/13  07:49:33  conrad
 * Syscalls for thread management added
 *
 * Revision 1.3  1997/02/12  13:02:00  zitzler
 * kernel syscalls for memory management added
 *
 * Revision 1.2  1997/02/12  10:32:43  zitzler
 * memory manager syscalls only
 *
 * Revision 1.1  1997/02/04  11:46:04  topsy
 * Initial revision
 *
*/

#ifndef _SYSCALL_H_
#define _SYSCALL_H_

#include "Topsy.h"
#include "Messages.h"
#include "Memory.h"
#include "Threads.h"
#include "IO.h"

#define SyscallError  MessageError


/* memory management */

SyscallError  vmAlloc(Address *addressPtr, unsigned long int  size);
SyscallError  vmFree(Address address);
SyscallError  vmMove(Address *addressPtr, ThreadId newOwner);
SyscallError  vmProtect(Address  startAdr, unsigned long int  size,
                ProtectionMode  pmode);
SyscallError  vmCleanup(ThreadId threadId);

/* thread management */

SyscallError tmMsgSend( ThreadId to, Message *msg);
SyscallError tmMsgRecv( ThreadId* from,
			MessageId msgId,
			Message* msg,
			int timeOut);
SyscallError tmStart( ThreadId* id,
		      ThreadMainFunction mainFunction, 
		      ThreadArg parameter, 
		      char *name);
SyscallError tmKill(ThreadId id);
void tmExit();
void tmYield();
/* the famous info msg */
SyscallError tmGetInfo(ThreadId about, ThreadId* tid, ThreadId* ptid);
SyscallError tmGetFirst(ThreadInfo* info);
SyscallError tmGetNext(ThreadInfo* info);
SyscallError tmGetThreadByName(char* name, ThreadId* tid);
SyscallError tmGetIDInfo(ThreadId about, ThreadInfo* info);
/* timing stuff */
SyscallError tmGetTime(unsigned long* seconds, unsigned long* microSeconds); 
SyscallError tmSetTime(unsigned long seconds, unsigned long microSeconds); 


/* io interface */

SyscallError ioOpen(int deviceNumber, ThreadId* id);
SyscallError ioClose(ThreadId id);
SyscallError ioRead(ThreadId id, char* buffer, unsigned long int* nOfBytes);
SyscallError ioWrite(ThreadId id, char* buffer, unsigned long int* nOfBytes);
SyscallError ioInit(ThreadId id);
SyscallError ioSubscribe(ThreadId id, ThreadId from);
void ioGetAddr(ThreadId id, char *addr, int len);

#endif
