/*
    Support.h, Copyright  (c) by Christian Conrad,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
 	PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Topsy/Support.h,v $
 	Author(s):             Christian Conrad
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.10 $
 	Creation Date:         
 	Last Date of Change:   $Date: 2000/03/31 17:50:40 $      by: $Author: gfa $
	
	
	$Log: Support.h,v $
	Revision 1.10  2000/03/31 17:50:40  gfa
	Merged with /Net from several term projects
	
	Revision 1.9  1999/12/13 21:48:37  ruf
	GNU General Public Licence Update
	
	Revision 1.8  1999/10/23 14:19:48  jeker
	first cleanup for R4k support
	
	Revision 1.7  1999/10/21 20:22:32  jeker
	first commit for the R4k support

	Revision 1.6  1998/06/05 14:40:12  gfa
	get/set time

	Revision 1.5  1998/04/11 20:21:07  gfa
	added longCopy()

 * Revision 1.4  97/03/18  14:33:54  gfa
 * added testAndSet prototype
 * 
 * Revision 1.3  1997/03/16  22:14:24  gfa
 * added zeroOut
 *
 * Revision 1.2  1997/02/27  14:39:29  conrad
 * Adding of function stringCopy()
 *
 * Revision 1.1  1997/02/20  09:36:46  conrad
 * Initial revision
 *
*/

#ifndef __SUPPORT_H
#define __SUPPORT_H

#include "Topsy.h"
#include "IOConsole.h"
#include <stdarg.h>

/*
 * Copy nbBytes from address srcAddress to address targetAddress.
 * (equivalent to UNIX memcpy(), new name to avoid confusion).
 */
void byteCopy( Address targetAddress, Address sourceAddress, unsigned long int nbBytes);

/* fill memory with zeros */
void zeroOut(Address target, unsigned long int size);

/*
 * Copy a NULL-terminated string from source to target.
 * (equivalent to UNIX strcpy(), new name to avoid confusion).
 */
void stringCopy( char* target, char* source );

/* copies a string or at most the first size-1 bytes 
 * and terminates it with 0 
 */
void stringNCopy( char* target, char* source, unsigned long int size);

/* test strings if they are equal
 */
Boolean isStringEqual(char* s1, char* s2, int maxLength);

/* support function (in assembler) to test and set memory
 * in one atomic step
 */
Boolean testAndSet(Boolean* lockvar);

/* 
 * return string length 
 */
int stringLength(char* s);

/*
 * printk: nice printf like kernel output. no floats!
 */
int printk(char *fmt, ...);

#endif __SUPPORT_H
